/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextFactory;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class KernelTransactionsTest {
    @Test
    public void shouldListActiveTransactions() throws Exception {
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction first = registry.newInstance();
        KernelTransaction second = registry.newInstance();
        KernelTransaction third = registry.newInstance();
        first.close();
        Assert.assertThat((Object)IteratorUtil.asUniqueSet((Iterable)registry.activeTransactions()), (Matcher)CoreMatchers.equalTo((Object)IteratorUtil.asSet((Object[])new KernelTransaction[]{second, third})));
    }

    @Test
    public void shouldDisposeTransactionsWhenAsked() throws Exception {
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions();
        registry.disposeAll();
        KernelTransaction first = registry.newInstance();
        KernelTransaction second = registry.newInstance();
        KernelTransaction leftOpen = registry.newInstance();
        first.close();
        second.close();
        registry.disposeAll();
        KernelTransaction postDispose = registry.newInstance();
        Assert.assertThat((Object)postDispose, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)first)));
        Assert.assertThat((Object)postDispose, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)second)));
        Assert.assertTrue((boolean)leftOpen.shouldBeTerminated());
    }

    @Test
    public void shouldIncludeRandomBytesInAdditionalHeader() throws TransactionFailureException {
        TransactionRepresentation[] transactionRepresentation = new TransactionRepresentation[1];
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions(KernelTransactionsTest.newRememberingCommitProcess(transactionRepresentation), KernelTransactionsTest.newMockContextFactoryWithChanges());
        KernelTransaction transaction = registry.newInstance();
        transaction.success();
        transaction.close();
        byte[] additionalHeader = transactionRepresentation[0].additionalHeader();
        Assert.assertNotNull((Object)additionalHeader);
        Assert.assertTrue((additionalHeader.length > 0 ? 1 : 0) != 0);
    }

    private static KernelTransactions newKernelTransactions() {
        return KernelTransactionsTest.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), KernelTransactionsTest.newMockContextFactory());
    }

    private static KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess, NeoStoreTransactionContextFactory contextSupplier) {
        LifeSupport life = new LifeSupport();
        life.start();
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)locks.newClient()).thenReturn(Mockito.mock(Locks.Client.class));
        StoreReadLayer readLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)readLayer.acquireStatement()).thenReturn(Mockito.mock(StoreStatement.class));
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        Mockito.when((Object)neoStores.getMetaDataStore()).thenReturn(Mockito.mock(MetaDataStore.class));
        return new KernelTransactions(contextSupplier, neoStores, locks, (IntegrityValidator)Mockito.mock(IntegrityValidator.class), null, null, null, null, null, null, null, TransactionHeaderInformationFactory.DEFAULT, readLayer, commitProcess, null, null, new TransactionHooks(), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), life, new ProcedureCache(), new Tracers("null", (Log)NullLog.getInstance()));
    }

    private static TransactionCommitProcess newRememberingCommitProcess(final TransactionRepresentation[] slot) throws TransactionFailureException {
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        Mockito.when((Object)commitProcess.commit((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), (LockGroup)Matchers.any(LockGroup.class), (CommitEvent)Matchers.any(CommitEvent.class), (TransactionApplicationMode)Matchers.any(TransactionApplicationMode.class))).then((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                slot[0] = (TransactionRepresentation)invocation.getArguments()[0];
                return 1L;
            }
        });
        return commitProcess;
    }

    private static NeoStoreTransactionContextFactory newMockContextFactory() {
        NeoStoreTransactionContextFactory factory = (NeoStoreTransactionContextFactory)Mockito.mock(NeoStoreTransactionContextFactory.class);
        NeoStoreTransactionContext context = (NeoStoreTransactionContext)Mockito.mock(NeoStoreTransactionContext.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)factory.newInstance((Locks.Client)Matchers.any(Locks.Client.class))).thenReturn((Object)context);
        return factory;
    }

    private static NeoStoreTransactionContextFactory newMockContextFactoryWithChanges() {
        NeoStoreTransactionContextFactory factory = (NeoStoreTransactionContextFactory)Mockito.mock(NeoStoreTransactionContextFactory.class);
        NeoStoreTransactionContext context = (NeoStoreTransactionContext)Mockito.mock(NeoStoreTransactionContext.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)context.hasChanges()).thenReturn((Object)true);
        RecordAccess recordChanges = (RecordAccess)Mockito.mock(RecordAccess.class);
        Mockito.when((Object)recordChanges.changeSize()).thenReturn((Object)1);
        RecordAccess.RecordProxy recordChange = (RecordAccess.RecordProxy)Mockito.mock(RecordAccess.RecordProxy.class);
        Mockito.when((Object)recordChange.forReadingLinkage()).thenReturn((Object)new NodeRecord(1L, false, 1L, 1L));
        Mockito.when((Object)recordChanges.changes()).thenReturn((Object)Iterables.option((Object)recordChange));
        Mockito.when((Object)context.getNodeRecords()).thenReturn((Object)recordChanges);
        Mockito.when((Object)factory.newInstance((Locks.Client)Matchers.any(Locks.Client.class))).thenReturn((Object)context);
        return factory;
    }
}

