/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.api.DefaultTransactionTracer;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;

public class DefaultTransactionTracerTest {
    private final FakeClock clock = new FakeClock();

    @Test
    public void shouldComputeStartEndAndTotalTimeForLogRotation() throws Throwable {
        Throwable throwable;
        LogRotateEvent event;
        Throwable throwable2;
        LogAppendEvent logAppendEvent;
        Throwable throwable3;
        CommitEvent commitEvent;
        DefaultTransactionTracer tracer = new DefaultTransactionTracer((Clock)this.clock);
        try (TransactionEvent txEvent = tracer.beginTransaction();){
            commitEvent = txEvent.beginCommitEvent();
            throwable3 = null;
            try {
                logAppendEvent = commitEvent.beginLogAppend();
                throwable2 = null;
                try {
                    this.clock.forward(10L, TimeUnit.MILLISECONDS);
                    event = logAppendEvent.beginLogRotate();
                    throwable = null;
                    try {
                        this.clock.forward(20L, TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (event != null) {
                            if (throwable != null) {
                                try {
                                    event.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                event.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (logAppendEvent != null) {
                        if (throwable2 != null) {
                            try {
                                logAppendEvent.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            logAppendEvent.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable3 = x2;
                throw x2;
            }
            finally {
                if (commitEvent != null) {
                    if (throwable3 != null) {
                        try {
                            commitEvent.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        commitEvent.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)1L, (long)tracer.numberOfLogRotationEvents());
        Assert.assertEquals((long)20L, (long)tracer.logRotationAccumulatedTotalTimeMillis());
        txEvent = tracer.beginTransaction();
        var3_3 = null;
        try {
            commitEvent = txEvent.beginCommitEvent();
            throwable3 = null;
            try {
                logAppendEvent = commitEvent.beginLogAppend();
                throwable2 = null;
                try {
                    this.clock.forward(200L, TimeUnit.MILLISECONDS);
                    event = logAppendEvent.beginLogRotate();
                    throwable = null;
                    try {
                        this.clock.forward(30L, TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (event != null) {
                            if (throwable != null) {
                                try {
                                    event.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                event.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (logAppendEvent != null) {
                        if (throwable2 != null) {
                            try {
                                logAppendEvent.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            logAppendEvent.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable3 = throwable6;
                throw throwable6;
            }
            finally {
                if (commitEvent != null) {
                    if (throwable3 != null) {
                        try {
                            commitEvent.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        commitEvent.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            var3_3 = throwable7;
            throw throwable7;
        }
        finally {
            if (txEvent != null) {
                if (var3_3 != null) {
                    try {
                        txEvent.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    txEvent.close();
                }
            }
        }
        Assert.assertEquals((long)2L, (long)tracer.numberOfLogRotationEvents());
        Assert.assertEquals((long)50L, (long)tracer.logRotationAccumulatedTotalTimeMillis());
    }

    @Test
    public void shouldReturnMinusOneIfNoDataIsAvailableForLogRotation() throws Throwable {
        DefaultTransactionTracer tracer = new DefaultTransactionTracer((Clock)this.clock);
        Assert.assertEquals((long)0L, (long)tracer.numberOfLogRotationEvents());
        Assert.assertEquals((long)0L, (long)tracer.logRotationAccumulatedTotalTimeMillis());
    }
}

