/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Pair;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class DataAndSchemaTransactionSeparationIT {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();

    private static Function<GraphDatabaseService, Void> expectFailureAfterSchemaOperation(final Function<GraphDatabaseService, ?> function) {
        return new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService graphDb) {
                graphDb.schema().indexFor(DynamicLabel.label((String)"Label1")).on("key1").create();
                try {
                    function.apply((Object)graphDb);
                    Assert.fail((String)"expected exception");
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"Cannot perform data updates in a transaction that has performed schema updates.", (Object)e.getMessage());
                }
                return null;
            }
        };
    }

    private static Function<GraphDatabaseService, Void> succeedAfterSchemaOperation(final Function<GraphDatabaseService, ?> function) {
        return new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService graphDb) {
                graphDb.schema().indexFor(DynamicLabel.label((String)"Label1")).on("key1").create();
                function.apply((Object)graphDb);
                return null;
            }
        };
    }

    @Test
    public void shouldNotAllowNodeCreationInSchemaTransaction() throws Exception {
        this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(DataAndSchemaTransactionSeparationIT.createNode()));
    }

    @Test
    public void shouldNotAllowRelationshipCreationInSchemaTransaction() throws Exception {
        Pair<Node, Node> nodes = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.aPairOfNodes());
        this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(DataAndSchemaTransactionSeparationIT.relate(nodes)));
    }

    @Test
    public void shouldNotAllowPropertyWritesInSchemaTransaction() throws Exception {
        Pair<Node, Node> nodes = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.aPairOfNodes());
        Relationship relationship = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.relate(nodes));
        for (Function operation : new Function[]{DataAndSchemaTransactionSeparationIT.propertyWrite(Node.class, (PropertyContainer)nodes.first(), "key1", "value1"), DataAndSchemaTransactionSeparationIT.propertyWrite(Relationship.class, relationship, "key1", "value1")}) {
            this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(operation));
        }
    }

    @Test
    public void shouldAllowPropertyReadsInSchemaTransaction() throws Exception {
        Pair<Node, Node> nodes = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.aPairOfNodes());
        Relationship relationship = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.relate(nodes));
        this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.propertyWrite(Node.class, (PropertyContainer)nodes.first(), "key1", "value1"));
        this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.propertyWrite(Relationship.class, relationship, "key1", "value1"));
        for (Function operation : new Function[]{DataAndSchemaTransactionSeparationIT.propertyRead(Node.class, (PropertyContainer)nodes.first(), "key1"), DataAndSchemaTransactionSeparationIT.propertyRead(Relationship.class, relationship, "key1")}) {
            this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.succeedAfterSchemaOperation(operation));
        }
    }

    private static Function<GraphDatabaseService, Node> createNode() {
        return new Function<GraphDatabaseService, Node>(){

            public Node apply(GraphDatabaseService graphDb) {
                return graphDb.createNode();
            }
        };
    }

    private static <T extends PropertyContainer> Function<GraphDatabaseService, Object> propertyRead(Class<T> type, final T entity, final String key) {
        return new FailureRewrite<Object>(type.getSimpleName() + ".getProperty()"){

            @Override
            Object perform(GraphDatabaseService graphDb) {
                return entity.getProperty(key);
            }
        };
    }

    private static <T extends PropertyContainer> Function<GraphDatabaseService, Void> propertyWrite(Class<T> type, final T entity, final String key, final Object value) {
        return new FailureRewrite<Void>(type.getSimpleName() + ".setProperty()"){

            @Override
            Void perform(GraphDatabaseService graphDb) {
                entity.setProperty(key, value);
                return null;
            }
        };
    }

    private static Function<GraphDatabaseService, Pair<Node, Node>> aPairOfNodes() {
        return new Function<GraphDatabaseService, Pair<Node, Node>>(){

            public Pair<Node, Node> apply(GraphDatabaseService graphDb) {
                return Pair.of((Object)graphDb.createNode(), (Object)graphDb.createNode());
            }
        };
    }

    private static Function<GraphDatabaseService, Relationship> relate(final Pair<Node, Node> nodes) {
        return new Function<GraphDatabaseService, Relationship>(){

            public Relationship apply(GraphDatabaseService graphDb) {
                return ((Node)nodes.first()).createRelationshipTo((Node)nodes.other(), (RelationshipType)DynamicRelationshipType.withName((String)"RELATED"));
            }
        };
    }

    private static abstract class FailureRewrite<T>
    implements Function<GraphDatabaseService, T> {
        private final String message;

        FailureRewrite(String message) {
            this.message = message;
        }

        public T apply(GraphDatabaseService graphDb) {
            try {
                return this.perform(graphDb);
            }
            catch (AssertionError e) {
                AssertionError error = new AssertionError((Object)(this.message + ": " + ((Throwable)((Object)e)).getMessage()));
                ((Throwable)((Object)error)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
                throw error;
            }
        }

        abstract T perform(GraphDatabaseService var1);
    }
}

