/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;

public class TestConfigConcurrency {
    @Test(timeout=10000L)
    public void shouldHandleConcurrentLoad() throws Throwable {
        Config config = new Config();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<ConfigHammer> hammers = new ArrayList<ConfigHammer>();
        int numThreads = 10;
        while (numThreads-- > 0) {
            ConfigHammer configHammer = new ConfigHammer(config);
            Thread thread = new Thread(configHammer);
            thread.start();
            threads.add(thread);
            hammers.add(configHammer);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        for (ConfigHammer hammer : hammers) {
            if (hammer.failure == null) continue;
            throw hammer.failure;
        }
    }

    class ConfigHammer
    implements Runnable,
    ConfigurationChangeListener {
        private final Config config;
        private final Random rand;
        protected Throwable failure;

        public ConfigHammer(Config config) {
            this.config = config;
            this.rand = new Random();
        }

        @Override
        public void run() {
            try {
                int times = 500;
                while (times-- > 0) {
                    this.config.addConfigurationChangeListener((ConfigurationChangeListener)this);
                    Map params = this.config.getParams();
                    params.put("asd" + this.rand.nextInt(10), "dsa" + this.rand.nextInt(100000));
                    this.config.applyChanges(params);
                    this.config.removeConfigurationChangeListener((ConfigurationChangeListener)this);
                }
            }
            catch (Throwable e) {
                this.failure = e;
            }
        }

        public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
        }
    }
}

