/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.logging.Log;

public class AnnotationBasedConfigurationMigratorTest {
    private static final AtomicBoolean wasCalled = new AtomicBoolean(false);

    @Test
    public void migratorShouldGetPickedUp() {
        AnnotationBasedConfigurationMigrator migrator = new AnnotationBasedConfigurationMigrator(Arrays.asList(SomeSettings.class));
        migrator.apply(new HashMap(), null);
        Assert.assertThat((Object)wasCalled.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    static class SomeSettings {
        @Migrator
        private static ConfigurationMigrator migrator = new ConfigurationMigrator(){

            public Map<String, String> apply(Map<String, String> rawConfiguration, Log log) {
                wasCalled.set(true);
                return rawConfiguration;
            }
        };

        SomeSettings() {
        }
    }
}

