/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.function.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.properties.BooleanProperty;
import org.neo4j.kernel.api.properties.ByteProperty;
import org.neo4j.kernel.api.properties.CharArrayProperty;
import org.neo4j.kernel.api.properties.CharProperty;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.DoubleProperty;
import org.neo4j.kernel.api.properties.FloatProperty;
import org.neo4j.kernel.api.properties.IntArrayProperty;
import org.neo4j.kernel.api.properties.LongProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.ShortProperty;
import org.neo4j.kernel.api.properties.StringArrayProperty;
import org.neo4j.kernel.api.properties.StringProperty;

@RunWith(value=Parameterized.class)
public class PropertyEqualityTest {
    private Test currentTest;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        Iterable testValues = IteratorUtil.asIterable((Object[])new Test[]{PropertyEqualityTest.shouldMatch(true, (Object)true), PropertyEqualityTest.shouldMatch(false, (Object)false), PropertyEqualityTest.shouldNotMatch(true, (Object)false), PropertyEqualityTest.shouldNotMatch(false, (Object)true), PropertyEqualityTest.shouldNotMatch(true, (Object)0), PropertyEqualityTest.shouldNotMatch(false, (Object)0), PropertyEqualityTest.shouldNotMatch(true, (Object)1), PropertyEqualityTest.shouldNotMatch(false, (Object)1), PropertyEqualityTest.shouldNotMatch(false, (Object)"false"), PropertyEqualityTest.shouldNotMatch(true, (Object)"true"), PropertyEqualityTest.shouldMatch((byte)42, (Object)42), PropertyEqualityTest.shouldMatch((byte)42, (Object)42), PropertyEqualityTest.shouldNotMatch((byte)42, (Object)298), PropertyEqualityTest.shouldMatch((byte)43, (Object)43), PropertyEqualityTest.shouldMatch((byte)43, (Object)43L), PropertyEqualityTest.shouldMatch((byte)23, (Object)23.0), PropertyEqualityTest.shouldMatch((byte)23, (Object)Float.valueOf(23.0f)), PropertyEqualityTest.shouldNotMatch((byte)23, (Object)23.5), PropertyEqualityTest.shouldNotMatch((byte)23, (Object)Float.valueOf(23.5f)), PropertyEqualityTest.shouldMatch((short)11, (Object)11), PropertyEqualityTest.shouldMatch((short)42, (Object)42), PropertyEqualityTest.shouldNotMatch((short)42, (Object)65578), PropertyEqualityTest.shouldMatch((short)43, (Object)43), PropertyEqualityTest.shouldMatch((short)43, (Object)43L), PropertyEqualityTest.shouldMatch((short)23, (Object)Float.valueOf(23.0f)), PropertyEqualityTest.shouldMatch((short)23, (Object)23.0), PropertyEqualityTest.shouldNotMatch((short)23, (Object)23.5), PropertyEqualityTest.shouldNotMatch((short)23, (Object)Float.valueOf(23.5f)), PropertyEqualityTest.shouldMatch(11L, (Object)11), PropertyEqualityTest.shouldMatch(42L, (Object)42), PropertyEqualityTest.shouldNotMatch(42L, (Object)4294967338L), PropertyEqualityTest.shouldMatch(43L, (Object)43), PropertyEqualityTest.shouldMatch(Integer.MAX_VALUE, (Object)Integer.MAX_VALUE), PropertyEqualityTest.shouldMatch(43L, (Object)43L), PropertyEqualityTest.shouldMatch(23L, (Object)23.0), PropertyEqualityTest.shouldNotMatch(23L, (Object)23.5), PropertyEqualityTest.shouldNotMatch(23L, (Object)Float.valueOf(23.5f)), PropertyEqualityTest.shouldMatch(11L, (Object)11), PropertyEqualityTest.shouldMatch(42L, (Object)42), PropertyEqualityTest.shouldMatch(43L, (Object)43), PropertyEqualityTest.shouldMatch(43L, (Object)43L), PropertyEqualityTest.shouldMatch(87L, (Object)87L), PropertyEqualityTest.shouldMatch(Long.MAX_VALUE, (Object)Long.MAX_VALUE), PropertyEqualityTest.shouldMatch(23L, (Object)23.0), PropertyEqualityTest.shouldNotMatch(23L, (Object)23.5), PropertyEqualityTest.shouldNotMatch(23L, (Object)Float.valueOf(23.5f)), PropertyEqualityTest.shouldMatch(0x20000000000000L, (Object)9.007199254740992E15), PropertyEqualityTest.shouldMatch(11.0f, (Object)11), PropertyEqualityTest.shouldMatch(42.0f, (Object)42), PropertyEqualityTest.shouldMatch(43.0f, (Object)43), PropertyEqualityTest.shouldMatch(43.0f, (Object)43L), PropertyEqualityTest.shouldMatch(23.0f, (Object)23.0), PropertyEqualityTest.shouldNotMatch(23.0f, (Object)23.5), PropertyEqualityTest.shouldNotMatch(23.0f, (Object)Float.valueOf(23.5f)), PropertyEqualityTest.shouldMatch(3.14f, (Object)Float.valueOf(3.14f)), PropertyEqualityTest.shouldNotMatch(3.14f, (Object)3.14), PropertyEqualityTest.shouldMatch(11.0, (Object)11), PropertyEqualityTest.shouldMatch(42.0, (Object)42), PropertyEqualityTest.shouldMatch(43.0, (Object)43), PropertyEqualityTest.shouldMatch(43.0, (Object)43L), PropertyEqualityTest.shouldMatch(23.0, (Object)23.0), PropertyEqualityTest.shouldNotMatch(23.0, (Object)23.5), PropertyEqualityTest.shouldNotMatch(23.0, (Object)Float.valueOf(23.5f)), PropertyEqualityTest.shouldNotMatch(3.14, (Object)Float.valueOf(3.14f)), PropertyEqualityTest.shouldMatch(3.14, (Object)3.14), PropertyEqualityTest.shouldMatch("A", (Object)"A"), PropertyEqualityTest.shouldMatch('A', (Object)Character.valueOf('A')), PropertyEqualityTest.shouldMatch('A', (Object)"A"), PropertyEqualityTest.shouldMatch("A", (Object)Character.valueOf('A')), PropertyEqualityTest.shouldNotMatch("AA", (Object)Character.valueOf('A')), PropertyEqualityTest.shouldNotMatch("a", (Object)"A"), PropertyEqualityTest.shouldNotMatch("A", (Object)"a"), PropertyEqualityTest.shouldNotMatch("0", (Object)0), PropertyEqualityTest.shouldNotMatch('0', (Object)0), PropertyEqualityTest.shouldMatch(new int[]{1, 2, 3}, (Object)new int[]{1, 2, 3}), PropertyEqualityTest.shouldMatch(new int[]{1, 2, 3}, (Object)new long[]{1L, 2L, 3L}), PropertyEqualityTest.shouldMatch(new int[]{1, 2, 3}, (Object)new double[]{1.0, 2.0, 3.0}), PropertyEqualityTest.shouldMatch(new String[]{"A", "B", "C"}, (Object)new String[]{"A", "B", "C"}), PropertyEqualityTest.shouldMatch(new String[]{"A", "B", "C"}, (Object)new char[]{'A', 'B', 'C'}), PropertyEqualityTest.shouldMatch(new char[]{'A', 'B', 'C'}, (Object)new String[]{"A", "B", "C"})});
        return IteratorUtil.asCollection((Iterable)Iterables.map((Function)new Function<Test, Object[]>(){

            public Object[] apply(Test testValue) {
                return new Object[]{testValue};
            }
        }, (Iterable)testValues));
    }

    public PropertyEqualityTest(Test currentTest) {
        this.currentTest = currentTest;
    }

    @org.junit.Test
    public void runTest() {
        this.currentTest.checkAssertion();
    }

    public static Test shouldMatch(boolean propertyValue, Object value) {
        return new Test((DefinedProperty)new BooleanProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(boolean propertyValue, Object value) {
        return new Test((DefinedProperty)new BooleanProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(byte propertyValue, Object value) {
        return new Test((DefinedProperty)new ByteProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(byte propertyValue, Object value) {
        return new Test((DefinedProperty)new ByteProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(short propertyValue, Object value) {
        return new Test((DefinedProperty)new ShortProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(short propertyValue, Object value) {
        return new Test((DefinedProperty)new ShortProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(float propertyValue, Object value) {
        return new Test((DefinedProperty)new FloatProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(float propertyValue, Object value) {
        return new Test((DefinedProperty)new FloatProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(long propertyValue, Object value) {
        return new Test((DefinedProperty)new LongProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(long propertyValue, Object value) {
        return new Test((DefinedProperty)new LongProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(double propertyValue, Object value) {
        return new Test((DefinedProperty)new DoubleProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(double propertyValue, Object value) {
        return new Test((DefinedProperty)new DoubleProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(String propertyValue, Object value) {
        return new Test((DefinedProperty)new StringProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(String propertyValue, Object value) {
        return new Test((DefinedProperty)new StringProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(char propertyValue, Object value) {
        return new Test((DefinedProperty)new CharProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(char propertyValue, Object value) {
        return new Test((DefinedProperty)new CharProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(int[] propertyValue, Object value) {
        return new Test((DefinedProperty)new IntArrayProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(int[] propertyValue, Object value) {
        return new Test((DefinedProperty)new IntArrayProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(char[] propertyValue, Object value) {
        return new Test((DefinedProperty)new CharArrayProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(char[] propertyValue, Object value) {
        return new Test((DefinedProperty)new CharArrayProperty(0, propertyValue), value, false);
    }

    public static Test shouldMatch(String[] propertyValue, Object value) {
        return new Test((DefinedProperty)new StringArrayProperty(0, propertyValue), value, true);
    }

    public static Test shouldNotMatch(String[] propertyValue, Object value) {
        return new Test((DefinedProperty)new StringArrayProperty(0, propertyValue), value, false);
    }

    private static class Test {
        final DefinedProperty property;
        final Object value;
        final boolean shouldMatch;

        private Test(DefinedProperty property, Object value, boolean shouldMatch) {
            this.property = property;
            this.value = value;
            this.shouldMatch = shouldMatch;
        }

        public String toString() {
            return String.format("%s (%s) %s %s (%s)", this.property.value(), this.property.value().getClass().getSimpleName(), this.shouldMatch ? "==" : "!=", this.value, this.value.getClass().getSimpleName());
        }

        void checkAssertion() {
            if (this.shouldMatch) {
                this.assertEquality((Property)this.property, this.value);
            } else {
                this.assertNonEquality((Property)this.property, this.value);
            }
        }

        void assertEquality(Property property, Object value) {
            Assert.assertTrue((String)String.format("Expected the value %s to be equal to %s but it wasn't.", this.getValueRepresentation(value), property.toString()), (boolean)property.valueEquals(value));
        }

        private String getValueRepresentation(Object value) {
            String valueRepresentation;
            String className = value.getClass().getSimpleName();
            if (value.getClass().isArray()) {
                if (value instanceof Object[]) {
                    valueRepresentation = Arrays.toString((Object[])value);
                } else {
                    int length = Array.getLength(value);
                    Object[] objArr = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        objArr[i] = Array.get(value, i);
                    }
                    valueRepresentation = Arrays.toString(objArr);
                }
            } else {
                valueRepresentation = value.toString();
            }
            return valueRepresentation + " of type " + className;
        }

        void assertNonEquality(Property property, Object value) {
            Assert.assertFalse((String)String.format("Expected the value %s to not be equal to %s but it was.", this.getValueRepresentation(value), property.toString()), (boolean)property.valueEquals(value));
        }
    }
}

