/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class UniqueConstraintCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    private static final long COLLISION_X = 0x4000000000000001L;
    private static final long COLLISION_Y = 0x4000000000000003L;
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private Label label = DynamicLabel.label((String)"Cybermen");
    private String property = "name";
    private Node a;
    private Node b;
    private Node c;
    private Node d;
    private GraphDatabaseService db;
    private final Action success = new Action("tx.success();"){

        public void accept(Transaction transaction) {
            transaction.success();
            transaction.close();
        }
    };
    private final Map<Transaction, TopLevelTransaction> txMap = new IdentityHashMap<Transaction, TopLevelTransaction>();
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    public UniqueConstraintCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite);
    }

    @Test
    public void onlineConstraintShouldAcceptDistinctValuesInDifferentTransactions() {
        Node n;
        this.givenOnlineConstraint();
        try (Transaction tx = this.db.beginTx();){
            n = this.db.createNode(new Label[]{this.label});
            n.setProperty(this.property, (Object)"n");
            tx.success();
        }
        this.transaction(this.assertLookupNode("a", (Matcher<Node>)Matchers.is((Object)this.a)), this.assertLookupNode("n", (Matcher<Node>)Matchers.is((Object)n)));
    }

    @Test
    public void onlineConstraintShouldAcceptDistinctValuesInSameTransaction() {
        Node m;
        Node n;
        this.givenOnlineConstraint();
        try (Transaction tx = this.db.beginTx();){
            n = this.db.createNode(new Label[]{this.label});
            n.setProperty(this.property, (Object)"n");
            m = this.db.createNode(new Label[]{this.label});
            m.setProperty(this.property, (Object)"m");
            tx.success();
        }
        this.transaction(this.assertLookupNode("n", (Matcher<Node>)Matchers.is((Object)n)), this.assertLookupNode("m", (Matcher<Node>)Matchers.is((Object)m)));
    }

    @Ignore(value="Until constraint violation has been updated to double check with property store")
    @Test
    public void onlineConstrainthouldNotFalselyCollideOnFindNodesByLabelAndProperty() throws Exception {
        Node m;
        Node n;
        this.givenOnlineConstraint();
        try (Transaction tx = this.db.beginTx();){
            n = this.db.createNode(new Label[]{this.label});
            n.setProperty(this.property, (Object)0x4000000000000001L);
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            m = this.db.createNode(new Label[]{this.label});
            m.setProperty(this.property, (Object)0x4000000000000003L);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.transaction(this.assertLookupNode(0x4000000000000001L, (Matcher<Node>)Matchers.is((Object)n)), this.assertLookupNode(0x4000000000000003L, (Matcher<Node>)Matchers.is((Object)m)));
    }

    @Test
    public void onlineConstraintShouldNotConflictOnIntermediateStatesInSameTransaction() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "b"), this.setProperty(this.b, "a"), this.success);
        this.transaction(this.assertLookupNode("a", (Matcher<Node>)Matchers.is((Object)this.b)), this.assertLookupNode("b", (Matcher<Node>)Matchers.is((Object)this.a)));
    }

    @Test(expected=ConstraintViolationException.class)
    public void onlineConstraintShouldRejectChangingEntryToAlreadyIndexedValue() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.success);
        this.transaction(this.setProperty(this.b, "a"), this.success, this.fail("Changing a property to an already indexed value should have thrown"));
    }

    @Test(expected=ConstraintViolationException.class)
    public void onlineConstraintShouldRejectConflictsInTheSameTransaction() throws Exception {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "x"), this.setProperty(this.b, "x"), this.success, this.fail("Should have rejected changes of two node/properties to the same index value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void onlineConstraintShouldRejectChangingEntryToAlreadyIndexedValueThatOtherTransactionsAreRemoving() throws Exception {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.success);
        Transaction otherTx = this.db.beginTx();
        this.a.removeLabel(this.label);
        this.suspend(otherTx);
        try {
            this.transaction(this.setProperty(this.b, "a"), this.success, this.fail("Changing a property to an already indexed value should have thrown"));
        }
        catch (ConstraintViolationException constraintViolationException) {
        }
        finally {
            this.resume(otherTx);
            otherTx.failure();
            otherTx.close();
        }
    }

    @Test
    public void onlineConstraintShouldAddAndRemoveFromIndexAsPropertiesAndLabelsChange() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.success);
        this.transaction(this.setProperty(this.c, "c"), this.addLabel(this.c, this.label), this.success);
        this.transaction(this.setProperty(this.d, "d"), this.addLabel(this.d, this.label), this.success);
        this.transaction(this.removeProperty(this.a), this.success);
        this.transaction(this.removeProperty(this.b), this.success);
        this.transaction(this.removeProperty(this.c), this.success);
        this.transaction(this.setProperty(this.a, "a"), this.success);
        this.transaction(this.setProperty(this.c, "c2"), this.success);
        this.transaction(this.assertLookupNode("a", (Matcher<Node>)Matchers.is((Object)this.a)), this.assertLookupNode("b", (Matcher<Node>)Matchers.is((Matcher)Matchers.nullValue(Node.class))), this.assertLookupNode("c", (Matcher<Node>)Matchers.is((Matcher)Matchers.nullValue(Node.class))), this.assertLookupNode("d", (Matcher<Node>)Matchers.is((Object)this.d)), this.assertLookupNode("c2", (Matcher<Node>)Matchers.is((Object)this.c)));
    }

    @Test(expected=ConstraintViolationException.class)
    public void onlineConstraintShouldRejectConflictingPropertyChange() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "a"), this.success, this.fail("Setting b.name = \"a\" should have caused a conflict"));
    }

    @Test(expected=ConstraintViolationException.class)
    public void onlineConstraintShouldRejectConflictingLabelChange() {
        this.givenOnlineConstraint();
        this.transaction(this.addLabel(this.c, this.label), this.success, this.fail("Setting c:Cybermen should have caused a conflict"));
    }

    @Test(expected=ConstraintViolationException.class)
    public void onlineConstraintShouldRejectAddingEntryForValueAlreadyIndexedByPriorChange() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "a1"), this.success);
        this.transaction(this.setProperty(this.b, "a1"), this.success, this.fail("Setting b.name = \"a1\" should have caused a conflict"));
    }

    @Test
    public void onlineConstraintShouldAcceptUniqueEntries() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.addLabel(this.d, this.label), this.success);
        this.transaction(this.setProperty(this.c, "c"), this.addLabel(this.c, this.label), this.success);
        this.transaction(this.assertLookupNode("a", (Matcher<Node>)Matchers.is((Object)this.a)), this.assertLookupNode("b", (Matcher<Node>)Matchers.is((Object)this.b)), this.assertLookupNode("c", (Matcher<Node>)Matchers.is((Object)this.c)), this.assertLookupNode("d", (Matcher<Node>)Matchers.is((Object)this.d)));
    }

    @Test
    public void onlineConstraintShouldAcceptUniqueEntryChanges() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "a1"), this.success);
        this.transaction(this.assertLookupNode("a1", (Matcher<Node>)Matchers.is((Object)this.a)));
    }

    @Test(expected=ConstraintViolationException.class)
    public void onlineConstraintShouldRejectDuplicateEntriesAddedInSameTransaction() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "d"), this.addLabel(this.d, this.label), this.success, this.fail("Setting b.name = \"d\" and d:Cybermen should have caused a conflict"));
    }

    @Test
    public void populatingConstraintMustAcceptDatasetOfUniqueEntries() {
        this.givenUniqueDataset();
        this.createUniqueConstraint();
    }

    @Test(expected=ConstraintViolationException.class)
    public void populatingConstraintMustRejectDatasetWithDuplicateEntries() {
        this.givenUniqueDataset();
        this.transaction(this.setProperty(this.c, "b"), this.success);
        this.createUniqueConstraint();
    }

    @Test
    public void populatingConstraintMustAcceptDatasetWithDalseIndexCollisions() {
        this.givenUniqueDataset();
        this.transaction(this.setProperty(this.b, 0x4000000000000001L), this.setProperty(this.c, 0x4000000000000003L), this.success);
        this.createUniqueConstraint();
    }

    @Test
    public void populatingConstraintMustAcceptDatasetThatGetsUpdatedWithUniqueEntries() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "d1"));
        createConstraintTransaction.get();
    }

    @Test
    public void populatingConstraintMustRejectDatasetThatGetsUpdatedWithDuplicateAddition() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.createNode("b"));
        try {
            createConstraintTransaction.get();
            Assert.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConstraintViolationException.class));
        }
    }

    @Test
    public void populatingConstraintMustRejectDatasetThatGetsUpdatedWithDuplicates() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "b"));
        try {
            createConstraintTransaction.get();
            Assert.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConstraintViolationException.class));
        }
    }

    @Test
    public void populatingConstraintMustAcceptDatasetThatGestUpdatedWithFalseIndexCollisions() throws Exception {
        this.givenUniqueDataset();
        this.transaction(this.setProperty(this.a, 0x4000000000000001L), this.success);
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, 0x4000000000000003L));
        createConstraintTransaction.get();
    }

    @Test
    public void populatingConstraintMustRejectDatasetThatGetsUpdatedWithDuplicatesInSameTransaction() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "x"), this.setProperty(this.c, "x"));
        try {
            createConstraintTransaction.get();
            Assert.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConstraintViolationException.class));
        }
    }

    @Test
    public void populatingConstraintMustAcceptDatasetThatGetsUpdatedWithDuplicatesThatAreLaterResolved() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "b"), this.setProperty(this.b, "c"), this.setProperty(this.c, "d"));
        createConstraintTransaction.get();
    }

    @Test
    public void populatingUpdaterMustRejectDatasetWhereAdditionsConflictsWithPriorChanges() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "x"), this.createNode("x"));
        try {
            createConstraintTransaction.get();
            Assert.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConstraintViolationException.class));
        }
    }

    private Future<?> applyChangesToPopulatingUpdater(long blockDataChangeTransactionOnLockOnId, long blockPopulatorOnLockOnId, final Action ... actions) throws InterruptedException, ExecutionException {
        final CountDownLatch createNodeReadyLatch = new CountDownLatch(1);
        final CountDownLatch createNodeCommitLatch = new CountDownLatch(1);
        Future<?> updatingTransaction = executor.submit(new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = UniqueConstraintCompatibility.this.db.beginTx();){
                    for (Action action : actions) {
                        action.accept(tx);
                    }
                    tx.success();
                    createNodeReadyLatch.countDown();
                    UniqueConstraintCompatibility.awaitUninterruptibly(createNodeCommitLatch);
                }
            }
        });
        createNodeReadyLatch.await();
        Lock lockBlockingDataChangeTransaction = this.getLockService().acquireNodeLock(blockDataChangeTransactionOnLockOnId, LockService.LockType.WRITE_LOCK);
        Lock lockBlockingIndexPopulator = this.getLockService().acquireNodeLock(blockPopulatorOnLockOnId, LockService.LockType.WRITE_LOCK);
        final CountDownLatch createConstraintTransactionStarted = new CountDownLatch(1);
        Future<?> createConstraintTransaction = executor.submit(new Runnable(){

            @Override
            public void run() {
                UniqueConstraintCompatibility.this.createUniqueConstraint(createConstraintTransactionStarted);
            }
        });
        createConstraintTransactionStarted.await();
        createNodeCommitLatch.countDown();
        lockBlockingDataChangeTransaction.release();
        updatingTransaction.get();
        lockBlockingIndexPopulator.release();
        return createConstraintTransaction;
    }

    private void givenOnlineConstraint() {
        this.createUniqueConstraint();
        try (Transaction tx = this.db.beginTx();){
            this.a = this.db.createNode(new Label[]{this.label});
            this.a.setProperty(this.property, (Object)"a");
            this.b = this.db.createNode(new Label[]{this.label});
            this.c = this.db.createNode();
            this.c.setProperty(this.property, (Object)"a");
            this.d = this.db.createNode();
            this.d.setProperty(this.property, (Object)"d");
            tx.success();
        }
    }

    private void givenUniqueDataset() {
        try (Transaction tx = this.db.beginTx();){
            this.a = this.db.createNode(new Label[]{this.label});
            this.a.setProperty(this.property, (Object)"a");
            this.b = this.db.createNode(new Label[]{this.label});
            this.b.setProperty(this.property, (Object)"b");
            this.c = this.db.createNode(new Label[]{this.label});
            this.c.setProperty(this.property, (Object)"c");
            this.d = this.db.createNode(new Label[]{this.label});
            this.d.setProperty(this.property, (Object)"d");
            tx.success();
        }
    }

    private void createUniqueConstraint() {
        this.createUniqueConstraint(null);
    }

    private void createUniqueConstraint(CountDownLatch preCreateLatch) {
        try (Transaction tx = this.db.beginTx();){
            if (preCreateLatch != null) {
                preCreateLatch.countDown();
            }
            this.db.schema().constraintFor(this.label).assertPropertyIsUnique(this.property).create();
            tx.success();
        }
    }

    private Node lookUpNode(Object value) {
        return this.db.findNode(this.label, this.property, value);
    }

    public void transaction(Action ... actions) {
        int progress = 0;
        try (Transaction tx = this.db.beginTx();){
            for (Action action : actions) {
                action.accept(tx);
                ++progress;
            }
        }
        catch (Throwable ex) {
            StringBuilder sb = new StringBuilder("Transaction failed:\n\n");
            for (int i = 0; i < actions.length; ++i) {
                String mark = progress == i ? " failed --> " : "            ";
                sb.append(mark).append(actions[i]).append('\n');
            }
            ex.addSuppressed((Throwable)((Object)new AssertionError((Object)sb.toString())));
            throw ex;
        }
    }

    private Action createNode(final Object propertyValue) {
        return new Action("Node node = db.createNode( label ); node.setProperty( property, " + this.reprValue(propertyValue) + " );"){

            public void accept(Transaction transaction) {
                Node node = UniqueConstraintCompatibility.this.db.createNode(new Label[]{UniqueConstraintCompatibility.this.label});
                node.setProperty(UniqueConstraintCompatibility.this.property, propertyValue);
            }
        };
    }

    private Action setProperty(final Node node, final Object value) {
        return new Action(this.reprNode(node) + ".setProperty( property, " + this.reprValue(value) + " );"){

            public void accept(Transaction transaction) {
                node.setProperty(UniqueConstraintCompatibility.this.property, value);
            }
        };
    }

    private Action removeProperty(final Node node) {
        return new Action(this.reprNode(node) + ".removeProperty( property );"){

            public void accept(Transaction transaction) {
                node.removeProperty(UniqueConstraintCompatibility.this.property);
            }
        };
    }

    private Action addLabel(final Node node, final Label label) {
        return new Action(this.reprNode(node) + ".addLabel( " + label + " );"){

            public void accept(Transaction transaction) {
                node.addLabel(label);
            }
        };
    }

    private Action fail(final String message) {
        return new Action("fail( \"" + message + "\" );"){

            public void accept(Transaction transaction) {
                Assert.fail((String)message);
            }
        };
    }

    private Action assertLookupNode(final Object propertyValue, final Matcher<Node> matcher) {
        return new Action("assertThat( lookUpNode( " + this.reprValue(propertyValue) + " ), " + matcher + " );"){

            public void accept(Transaction transaction) {
                Assert.assertThat((Object)UniqueConstraintCompatibility.this.lookUpNode(propertyValue), (Matcher)matcher);
            }
        };
    }

    private String reprValue(Object value) {
        return value instanceof String ? "\"" + value + "\"" : String.valueOf(value);
    }

    private String reprNode(Node node) {
        return node == this.a ? "a" : (node == this.b ? "b" : (node == this.c ? "c" : (node == this.d ? "d" : "n")));
    }

    private void suspend(Transaction tx) throws Exception {
        ThreadToStatementContextBridge txManager = this.getTransactionManager();
        this.txMap.put(tx, txManager.getTopLevelTransactionBoundToThisThread(true));
        txManager.unbindTransactionFromCurrentThread();
    }

    private void resume(Transaction tx) throws Exception {
        ThreadToStatementContextBridge txManager = this.getTransactionManager();
        txManager.bindTransactionToCurrentThread(this.txMap.remove(tx));
    }

    private ThreadToStatementContextBridge getTransactionManager() {
        return this.resolveInternalDependency(ThreadToStatementContextBridge.class);
    }

    private LockService getLockService() {
        return this.resolveInternalDependency(LockService.class);
    }

    private <T> T resolveInternalDependency(Class<T> type) {
        GraphDatabaseAPI api = (GraphDatabaseAPI)this.db;
        DependencyResolver resolver = api.getDependencyResolver();
        return (T)resolver.resolveDependency(type);
    }

    private static void awaitUninterruptibly(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted", e);
        }
    }

    @Before
    public void setUp() {
        File storeDir = this.testDirectory.graphDbDir();
        TestGraphDatabaseFactory dbfactory = new TestGraphDatabaseFactory();
        dbfactory.addKernelExtension(new PredefinedSchemaIndexProviderFactory(this.indexProvider));
        this.db = dbfactory.newImpermanentDatabase(storeDir);
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    private static class PredefinedSchemaIndexProviderFactory
    extends KernelExtensionFactory<NoDeps> {
        private final SchemaIndexProvider indexProvider;

        public Lifecycle newKernelExtension(NoDeps noDeps) throws Throwable {
            return this.indexProvider;
        }

        public PredefinedSchemaIndexProviderFactory(SchemaIndexProvider indexProvider) {
            super(indexProvider.getClass().getSimpleName());
            this.indexProvider = indexProvider;
        }

        public static interface NoDeps {
        }
    }

    private abstract class Action
    implements Consumer<Transaction> {
        private final String name;

        protected Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

