/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionFactory;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;

public class TransactionStatementSharingTest {
    @Test
    public void shouldShareStatementStateForConcurrentReadStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        ReadOperations stmt1 = tx.acquireStatement().readOperations();
        ReadOperations stmt2 = tx.acquireStatement().readOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentReadStatementAndDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        ReadOperations stmt1 = tx.acquireStatement().readOperations();
        DataWriteOperations stmt2 = tx.acquireStatement().dataWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentReadStatementAndSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        ReadOperations stmt1 = tx.acquireStatement().readOperations();
        SchemaWriteOperations stmt2 = tx.acquireStatement().schemaWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentDataStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        DataWriteOperations stmt1 = tx.acquireStatement().dataWriteOperations();
        ReadOperations stmt2 = tx.acquireStatement().readOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentDataStatementAndDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        DataWriteOperations stmt1 = tx.acquireStatement().dataWriteOperations();
        DataWriteOperations stmt2 = tx.acquireStatement().dataWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentSchemaStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        SchemaWriteOperations stmt1 = tx.acquireStatement().schemaWriteOperations();
        ReadOperations stmt2 = tx.acquireStatement().readOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentSchemaStatementAndSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        SchemaWriteOperations stmt1 = tx.acquireStatement().schemaWriteOperations();
        SchemaWriteOperations stmt2 = tx.acquireStatement().schemaWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldNotShareStateForSequentialReadStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction();
        Statement statement = tx.acquireStatement();
        ReadOperations ops1 = statement.readOperations();
        statement.close();
        ReadOperations ops2 = tx.acquireStatement().readOperations();
        Assert.assertNotSame((Object)ops1, (Object)ops2);
    }
}

