/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.Config;

public class GraphDatabaseSettingsTest {
    @Test
    public void mustHaveReasonableDefaultPageCacheMemorySizeInBytes() throws Exception {
        long bytes = (Long)new Config().get(GraphDatabaseSettings.pagecache_memory);
        Assert.assertThat((Object)bytes, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(ByteUnit.mebiBytes((long)32L))));
        Assert.assertThat((Object)bytes, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(ByteUnit.tebiBytes((long)1L))));
    }

    @Test
    public void pageCacheSettingMustAcceptArbitraryUserSpecifiedValue() throws Exception {
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        String name = setting.name();
        Assert.assertThat((Object)new Config(MapUtil.stringMap((String[])new String[]{name, "245760"})).get(setting), (Matcher)Matchers.is((Object)ByteUnit.kibiBytes((long)240L)));
        Assert.assertThat((Object)new Config(MapUtil.stringMap((String[])new String[]{name, "2244g"})).get(setting), (Matcher)Matchers.is((Object)ByteUnit.gibiBytes((long)2244L)));
    }

    @Test(expected=InvalidSettingException.class)
    public void pageCacheSettingMustRejectOverlyConstrainedMemorySetting() throws Exception {
        long pageSize = (Long)new Config().get(GraphDatabaseSettings.mapped_memory_page_size);
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        String name = setting.name();
        new Config(MapUtil.stringMap((String[])new String[]{name, "" + (pageSize * 2L - 1L)})).get(setting);
    }
}

