/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Assert;
import org.junit.Rule;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.test.EmbeddedDatabaseRule;

public abstract class AbstractMandatoryTransactionsTest<T> {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule();

    public T obtainEntity() {
        GraphDatabaseService graphDatabaseService = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = graphDatabaseService.beginTx();){
            T result = this.obtainEntityInTransaction(graphDatabaseService);
            tx.success();
            T t = result;
            return t;
        }
    }

    public void obtainEntityInTerminatedTransaction(Consumer<T> f) {
        GraphDatabaseService graphDatabaseService = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = graphDatabaseService.beginTx();){
            T result = this.obtainEntityInTransaction(graphDatabaseService);
            tx.terminate();
            f.accept(result);
        }
    }

    protected abstract T obtainEntityInTransaction(GraphDatabaseService var1);

    public static <T> void assertFacadeMethodsThrowNotInTransaction(T entity, Iterable<FacadeMethod<T>> methods) {
        for (FacadeMethod<T> method : methods) {
            try {
                method.call(entity);
                Assert.fail((String)("Transactions are mandatory, also for reads: " + method));
            }
            catch (NotInTransactionException notInTransactionException) {}
        }
    }

    public void assertFacadeMethodsThrowAfterTerminate(Iterable<FacadeMethod<T>> methods) {
        for (final FacadeMethod<T> method : methods) {
            this.obtainEntityInTerminatedTransaction(new Consumer<T>(){

                public void accept(T entity) {
                    try {
                        method.call(entity);
                        Assert.fail((String)("Transaction was terminated, yet not exception thrown in: " + method));
                    }
                    catch (TransactionTerminatedException transactionTerminatedException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

