/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;

public class FacadeMethod<T>
implements Consumer<T> {
    public static final Label LABEL = Label.label((String)"Label");
    public static final RelationshipType FOO = RelationshipType.withName((String)"foo");
    public static final RelationshipType BAR = RelationshipType.withName((String)"bar");
    public static final Label QUUX = Label.label((String)"quux");
    public static final IndexDefinition INDEX_DEFINITION = (IndexDefinition)Mockito.mock(IndexDefinition.class);
    private final String methodSignature;
    private final Consumer<T> callable;

    public FacadeMethod(String methodSignature, Consumer<T> callable) {
        this.methodSignature = methodSignature;
        this.callable = callable;
    }

    @Override
    public void accept(T t) {
        this.callable.accept(t);
    }

    public void call(T self) {
        this.callable.accept(self);
    }

    public String toString() {
        return this.methodSignature;
    }

    public static <T> void consume(Iterator<T> iterator) {
        Iterable iterable = () -> iterator;
        FacadeMethod.consume(iterable);
    }

    public static void consume(Iterable<?> iterable) {
        for (Object o : iterable) {
            Assertions.assertNotNull(o);
        }
    }
}

