/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.progress.ProgressListener;

public class BatchTransaction
implements AutoCloseable {
    private static final int DEFAULT_INTERMEDIARY_SIZE = 10000;
    private final GraphDatabaseService db;
    private Transaction tx;
    private int txSize;
    private int total;
    private int intermediarySize = 10000;
    private ProgressListener progressListener = ProgressListener.NONE;

    public static BatchTransaction beginBatchTx(GraphDatabaseService db) {
        return new BatchTransaction(db);
    }

    private BatchTransaction(GraphDatabaseService db) {
        this.db = db;
        this.beginTx();
    }

    private void beginTx() {
        this.tx = this.db.beginTx();
    }

    public GraphDatabaseService getDb() {
        return this.db;
    }

    public boolean increment() {
        return this.increment(1);
    }

    public boolean increment(int count) {
        this.txSize += count;
        this.total += count;
        this.progressListener.add((long)count);
        if (this.txSize >= this.intermediarySize) {
            this.txSize = 0;
            this.intermediaryCommit();
            return true;
        }
        return false;
    }

    public void intermediaryCommit() {
        this.closeTx();
        this.beginTx();
    }

    private void closeTx() {
        this.tx.commit();
    }

    @Override
    public void close() {
        this.closeTx();
        this.progressListener.close();
    }

    public int total() {
        return this.total;
    }

    public BatchTransaction withIntermediarySize(int intermediarySize) {
        this.intermediarySize = intermediarySize;
        return this;
    }

    public BatchTransaction withProgress(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }
}

