/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.storageengine.api.LogVersionRepository;

public class SimpleLogVersionRepository
implements LogVersionRepository {
    private final AtomicLong logVersion = new AtomicLong();
    private final AtomicLong checkpointLogVersion = new AtomicLong();

    public SimpleLogVersionRepository() {
        this(0L, 0L);
    }

    public SimpleLogVersionRepository(long initialLogVersion) {
        this(initialLogVersion, initialLogVersion);
    }

    public SimpleLogVersionRepository(long initialLogVersion, long initialCheckpointLogVersion) {
        this.logVersion.set(initialLogVersion);
        this.checkpointLogVersion.set(initialCheckpointLogVersion);
    }

    public long incrementAndGetVersion() {
        return this.logVersion.incrementAndGet();
    }

    public long getCurrentLogVersion() {
        return this.logVersion.get();
    }

    public void setCurrentLogVersion(long version) {
        this.logVersion.set(version);
    }

    public long getCheckpointLogVersion() {
        return this.checkpointLogVersion.get();
    }

    public void setCheckpointLogVersion(long version) {
        this.checkpointLogVersion.set(version);
    }

    public long incrementAndGetCheckpointLogVersion() {
        return this.checkpointLogVersion.incrementAndGet();
    }
}

