/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.ProbingQuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscriberProbe;
import org.neo4j.values.AnyValue;

public class RecordingQuerySubscriber
extends ProbingQuerySubscriber
implements QuerySubscriber {
    private List<AnyValue[]> all = new ArrayList<AnyValue[]>();
    private AnyValue[] current;
    private Throwable throwable;
    private QueryStatistics statistics = QueryStatistics.EMPTY;

    public RecordingQuerySubscriber(QuerySubscriberProbe probe) {
        super(probe);
    }

    public RecordingQuerySubscriber() {
    }

    @Override
    public void onResult(int numberOfFields) {
        super.onResult(numberOfFields);
        this.current = new AnyValue[numberOfFields];
    }

    @Override
    public void onField(int offset, AnyValue value) {
        super.onField(offset, value);
        this.current[offset] = value;
    }

    @Override
    public void onRecordCompleted() {
        super.onRecordCompleted();
        this.all.add(Arrays.copyOf(this.current, this.current.length));
    }

    @Override
    public void onError(Throwable throwable) {
        super.onError(throwable);
        if (this.throwable == null) {
            this.throwable = throwable;
        }
    }

    @Override
    public void onResultCompleted(QueryStatistics statistics) {
        super.onResultCompleted(statistics);
        this.statistics = statistics;
    }

    public List<AnyValue[]> getOrThrow() throws Throwable {
        this.assertNoErrors();
        return this.all;
    }

    public void assertNoErrors() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
    }

    public QueryStatistics queryStatistics() {
        return this.statistics;
    }
}

