/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QuerySubscriberProbe;
import org.neo4j.values.AnyValue;

public class ChainableQuerySubscriberProbe
implements QuerySubscriberProbe {
    private final QuerySubscriberProbe probe;
    private QuerySubscriberProbe next;

    public ChainableQuerySubscriberProbe(QuerySubscriberProbe probe) {
        this.probe = probe;
    }

    public ChainableQuerySubscriberProbe() {
        this.probe = null;
    }

    public ChainableQuerySubscriberProbe chain(QuerySubscriberProbe probe) {
        this.next = probe;
        return this;
    }

    @Override
    public void onResult(int numberOfFields) {
        if (this.probe != null) {
            this.probe.onResult(numberOfFields);
        }
        if (this.next != null) {
            this.next.onResult(numberOfFields);
        }
    }

    @Override
    public void onRecord() {
        if (this.probe != null) {
            this.probe.onRecord();
        }
        if (this.next != null) {
            this.next.onRecord();
        }
    }

    @Override
    public void onField(int offset, AnyValue value) {
        if (this.probe != null) {
            this.probe.onField(offset, value);
        }
        if (this.next != null) {
            this.next.onField(offset, value);
        }
    }

    @Override
    public void onRecordCompleted() {
        if (this.probe != null) {
            this.probe.onRecordCompleted();
        }
        if (this.next != null) {
            this.next.onRecordCompleted();
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.probe != null) {
            this.probe.onError(throwable);
        }
        if (this.next != null) {
            this.next.onError(throwable);
        }
    }

    @Override
    public void onResultCompleted(QueryStatistics statistics) {
        if (this.probe != null) {
            this.probe.onResultCompleted(statistics);
        }
        if (this.next != null) {
            this.next.onResultCompleted(statistics);
        }
    }
}

