/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.util.Map;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.token.TokenHolders;

public interface Input
extends AutoCloseable {
    public InputIterable nodes(Collector var1);

    public InputIterable relationships(Collector var1);

    public IdType idType();

    public ReadableGroups groups();

    public Estimates calculateEstimates(PropertySizeCalculator var1) throws IOException;

    default public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void close() {
    }

    public static Input input(final InputIterable nodes, final InputIterable relationships, final IdType idType, final Estimates estimates, final ReadableGroups groups) {
        return new Input(){

            @Override
            public InputIterable relationships(Collector badCollector) {
                return relationships;
            }

            @Override
            public InputIterable nodes(Collector badCollector) {
                return nodes;
            }

            @Override
            public IdType idType() {
                return idType;
            }

            @Override
            public ReadableGroups groups() {
                return groups;
            }

            @Override
            public Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) {
                return estimates;
            }
        };
    }

    public static Estimates knownEstimates(final long numberOfNodes, final long numberOfRelationships, final long numberOfNodeProperties, final long numberOfRelationshipProperties, final long nodePropertiesSize, final long relationshipPropertiesSize, final long numberOfNodeLabels) {
        return new Estimates(){

            @Override
            public long numberOfNodes() {
                return numberOfNodes;
            }

            @Override
            public long numberOfRelationships() {
                return numberOfRelationships;
            }

            @Override
            public long numberOfNodeProperties() {
                return numberOfNodeProperties;
            }

            @Override
            public long sizeOfNodeProperties() {
                return nodePropertiesSize;
            }

            @Override
            public long numberOfNodeLabels() {
                return numberOfNodeLabels;
            }

            @Override
            public long numberOfRelationshipProperties() {
                return numberOfRelationshipProperties;
            }

            @Override
            public long sizeOfRelationshipProperties() {
                return relationshipPropertiesSize;
            }
        };
    }

    public static interface Estimates {
        public long numberOfNodes();

        public long numberOfRelationships();

        public long numberOfNodeProperties();

        public long numberOfRelationshipProperties();

        public long sizeOfNodeProperties();

        public long sizeOfRelationshipProperties();

        public long numberOfNodeLabels();
    }
}

