/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitorWithProperties;
import org.neo4j.util.Preconditions;

public interface RelationshipModifications {
    public static final RelationshipBatch EMPTY_BATCH = new RelationshipBatch(){

        @Override
        public int size() {
            return 0;
        }

        public <T extends Exception> void forEach(RelationshipVisitorWithProperties<T> relationship) {
        }
    };

    public static IdDataDecorator noAdditionalDataDecorator() {
        return IdDataDecorator.EMPTY_ID_DATA_DECORATOR;
    }

    public static RelationshipBatch idsAsBatch(LongSet ids) {
        return RelationshipModifications.idsAsBatch(ids, RelationshipModifications.noAdditionalDataDecorator());
    }

    public static RelationshipBatch idsAsBatch(final LongSet ids, final IdDataDecorator idDataDecorator) {
        return new RelationshipBatch(){

            @Override
            public int size() {
                return ids.size();
            }

            @Override
            public boolean isEmpty() {
                return ids.isEmpty();
            }

            @Override
            public boolean contains(long id) {
                return ids.contains(id);
            }

            @Override
            public long first() {
                return ids.longIterator().next();
            }

            @Override
            public <E extends Exception> void forEach(RelationshipVisitorWithProperties<E> relationship) throws E {
                LongIterator iterator = ids.longIterator();
                while (iterator.hasNext()) {
                    long id = iterator.next();
                    idDataDecorator.accept(id, relationship);
                }
            }
        };
    }

    public void forEachSplit(IdsVisitor var1);

    public RelationshipBatch creations();

    public RelationshipBatch deletions();

    public RelationshipBatch updates();

    public static interface IdDataDecorator {
        public static final IdDataDecorator EMPTY_ID_DATA_DECORATOR = new EmptyDataDecorator();

        public <E extends Exception> void accept(long var1, RelationshipVisitorWithProperties<E> var3) throws E;
    }

    public static interface RelationshipBatch {
        public int size();

        public <E extends Exception> void forEach(RelationshipVisitorWithProperties<E> var1) throws E;

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        default public boolean contains(long id) {
            if (this.isEmpty()) {
                return false;
            }
            MutableBoolean contains = new MutableBoolean();
            this.forEach((rId, type, start, end, addedProps, changedProps, removedProps) -> {
                if (rId == id) {
                    contains.setTrue();
                }
            });
            return contains.booleanValue();
        }

        default public long first() {
            Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"No ids");
            MutableLong first = new MutableLong(-1L);
            this.forEach((rId, type, start, end, addedProps, changedProps, removedProps) -> {
                if (first.longValue() == -1L) {
                    first.setValue(rId);
                }
            });
            return first.longValue();
        }
    }

    public static class EmptyDataDecorator
    implements IdDataDecorator {
        private EmptyDataDecorator() {
        }

        @Override
        public <E extends Exception> void accept(long id, RelationshipVisitorWithProperties<E> visitor) throws E {
            visitor.visit(id, -1, -1L, -1L, Collections.emptyList(), Collections.emptyList(), (IntIterable)IntLists.immutable.empty());
        }
    }

    public static interface NodeRelationshipTypeIds {
        public int type();

        default public RelationshipBatch ids(RelationshipDirection direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case RelationshipDirection.OUTGOING -> this.out();
                case RelationshipDirection.INCOMING -> this.in();
                case RelationshipDirection.LOOP -> this.loop();
            };
        }

        public boolean hasOut();

        public boolean hasIn();

        public boolean hasLoop();

        public RelationshipBatch out();

        public RelationshipBatch in();

        public RelationshipBatch loop();
    }

    public static interface NodeRelationshipIds {
        public long nodeId();

        public boolean hasCreations();

        public boolean hasCreations(int var1);

        public boolean hasDeletions();

        public boolean hasUpdates();

        public RelationshipBatch creations();

        public RelationshipBatch deletions();

        default public void forEachCreationSplit(TypeIdsVisitor visitor) {
            this.forEachCreationSplitInterruptible(byType -> {
                visitor.accept(byType);
                return false;
            });
        }

        public void forEachCreationSplitInterruptible(InterruptibleTypeIdsVisitor var1);

        default public void forEachDeletionSplit(TypeIdsVisitor visitor) {
            this.forEachDeletionSplitInterruptible(byType -> {
                visitor.accept(byType);
                return false;
            });
        }

        public void forEachDeletionSplitInterruptible(InterruptibleTypeIdsVisitor var1);

        default public void forEachUpdateSplit(TypeIdsVisitor visitor) {
            this.forEachUpdateSplitInterruptible(byType -> {
                visitor.accept(byType);
                return false;
            });
        }

        public void forEachUpdateSplitInterruptible(InterruptibleTypeIdsVisitor var1);
    }

    public static interface InterruptibleTypeIdsVisitor
    extends Predicate<NodeRelationshipTypeIds> {
    }

    public static interface TypeIdsVisitor
    extends Consumer<NodeRelationshipTypeIds> {
    }

    public static interface IdsVisitor
    extends Consumer<NodeRelationshipIds> {
    }
}

