/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.storageengine.api.DirectedTypes;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.txstate.NodeState;

public abstract class RelationshipSelection {
    public static final RelationshipSelection ALL_RELATIONSHIPS = new RelationshipSelection(){

        @Override
        public boolean test(int type) {
            return true;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return true;
        }

        @Override
        public Direction direction(int type) {
            return Direction.BOTH;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return true;
        }

        @Override
        public RelationshipSelection reverse() {
            return this;
        }

        @Override
        public int numberOfCriteria() {
            return 1;
        }

        @Override
        public Direction criterionDirection(int index) {
            assert (index == 0);
            return Direction.BOTH;
        }

        @Override
        public int criterionType(int index) {
            assert (index == 0);
            return -1;
        }

        @Override
        public boolean isTypeLimited() {
            return false;
        }

        @Override
        public boolean isLimited() {
            return false;
        }

        @Override
        public int highestType() {
            return Integer.MAX_VALUE;
        }

        @Override
        public LongIterator addedRelationships(NodeState transactionState) {
            return transactionState.getAddedRelationships();
        }

        public String toString() {
            return "RelationshipSelection[*]";
        }
    };
    public static final RelationshipSelection NO_RELATIONSHIPS = new RelationshipSelection(){

        @Override
        public boolean test(int type) {
            return false;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return false;
        }

        @Override
        public Direction direction(int type) {
            return Direction.BOTH;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return false;
        }

        @Override
        public int numberOfCriteria() {
            return 0;
        }

        @Override
        public Direction criterionDirection(int index) {
            throw new IllegalArgumentException("Unknown criterion index " + index);
        }

        @Override
        public int criterionType(int index) {
            throw new IllegalArgumentException("Unknown criterion index " + index);
        }

        @Override
        public boolean isTypeLimited() {
            return true;
        }

        @Override
        public int highestType() {
            return -1;
        }

        @Override
        public LongIterator addedRelationships(NodeState transactionState) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        @Override
        public RelationshipSelection reverse() {
            return this;
        }

        public String toString() {
            return "RelationshipSelection[NOTHING]";
        }
    };

    public abstract boolean test(int var1);

    public abstract boolean test(RelationshipDirection var1);

    public abstract Direction direction(int var1);

    public abstract boolean test(int var1, RelationshipDirection var2);

    public abstract int numberOfCriteria();

    public abstract int criterionType(int var1);

    public abstract Direction criterionDirection(int var1);

    public abstract boolean isTypeLimited();

    public boolean isLimited() {
        return true;
    }

    public abstract int highestType();

    public abstract LongIterator addedRelationships(NodeState var1);

    public abstract RelationshipSelection reverse();

    public static RelationshipSelection selection(int[] types, Direction direction) {
        if (types == null) {
            return RelationshipSelection.selection(direction);
        }
        if (types.length == 0) {
            return NO_RELATIONSHIPS;
        }
        if (types.length == 1) {
            if (types[0] == -1) {
                return NO_RELATIONSHIPS;
            }
            return new DirectionalSingleType(types[0], direction);
        }
        return RelationshipSelection.directionalMultipleTypesSelection(types, direction);
    }

    private static RelationshipSelection directionalMultipleTypesSelection(int[] types, Direction direction) {
        int highest = -1;
        int toFilter = 0;
        for (int type : types) {
            highest = Math.max(highest, type);
            if (type != -1) continue;
            ++toFilter;
        }
        if (toFilter == 0) {
            return new DirectionalMultipleTypes((int[])types.clone(), direction, highest);
        }
        int[] filtered = new int[types.length - toFilter];
        int i = 0;
        for (int type : types) {
            if (type == -1) continue;
            filtered[i++] = type;
        }
        if (filtered.length == 0) {
            return NO_RELATIONSHIPS;
        }
        if (filtered.length == 1) {
            return new DirectionalSingleType(filtered[0], direction);
        }
        return new DirectionalMultipleTypes(filtered, direction, highest);
    }

    public static RelationshipSelection selection(int type, Direction direction) {
        if (type == -1) {
            return NO_RELATIONSHIPS;
        }
        return new DirectionalSingleType(type, direction);
    }

    public static RelationshipSelection selection(Direction direction) {
        return direction == Direction.BOTH ? ALL_RELATIONSHIPS : new DirectionalAllTypes(direction);
    }

    public static RelationshipSelection selection(DirectedTypes directedTypes) {
        if (directedTypes.allowsAll()) {
            return ALL_RELATIONSHIPS;
        }
        if (!directedTypes.hasTypesInBothDirections()) {
            if (!directedTypes.hasSomeOutgoing()) {
                return RelationshipSelection.selection(directedTypes.typesWithoutDirections(), Direction.INCOMING);
            }
            if (!directedTypes.hasSomeIncoming()) {
                return RelationshipSelection.selection(directedTypes.typesWithoutDirections(), Direction.OUTGOING);
            }
        } else if (!directedTypes.hasSomeOutgoing() && !directedTypes.hasSomeIncoming()) {
            return RelationshipSelection.selection(directedTypes.typesWithoutDirections(), Direction.BOTH);
        }
        return new MultiDirectionalMultiType(directedTypes);
    }

    private static class DirectionalSingleType
    extends DirectionalSingleCriterion {
        DirectionalSingleType(int type, Direction direction) {
            super(type, direction);
        }

        @Override
        public boolean test(int type) {
            return this.type == type;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return this.type == type && direction.matches(this.direction);
        }

        @Override
        public boolean isTypeLimited() {
            return true;
        }

        @Override
        public LongIterator addedRelationships(NodeState transactionState) {
            return transactionState.getAddedRelationships(this.direction, this.type);
        }

        @Override
        public RelationshipSelection reverse() {
            return Direction.BOTH.equals((Object)this.direction) ? this : new DirectionalSingleType(this.type, this.direction.reverse());
        }

        public String toString() {
            return "RelationshipSelection[type=" + this.type + ", " + this.direction + "]";
        }
    }

    private static class DirectionalMultipleTypes
    extends Directional {
        private final int[] types;
        private final int highestType;

        private DirectionalMultipleTypes(int[] types, Direction direction, int highestType) {
            super(direction);
            this.types = types;
            this.highestType = highestType;
        }

        @Override
        public boolean test(int type) {
            return ArrayUtils.contains((int[])this.types, (int)type);
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return this.test(type) && direction.matches(this.direction);
        }

        @Override
        public int numberOfCriteria() {
            return this.types.length;
        }

        @Override
        public boolean isTypeLimited() {
            return true;
        }

        @Override
        public Direction criterionDirection(int index) {
            assert (index < this.types.length);
            return this.direction;
        }

        @Override
        public int criterionType(int index) {
            assert (index < this.types.length);
            return this.types[index];
        }

        @Override
        public int highestType() {
            return this.highestType;
        }

        @Override
        public LongIterator addedRelationships(NodeState transactionState) {
            LongIterator[] all = new LongIterator[this.types.length];
            int index = 0;
            for (int i = 0; i < this.types.length; ++i) {
                if (DirectionalMultipleTypes.existsEarlier(this.types, i)) continue;
                all[index++] = transactionState.getAddedRelationships(this.direction, this.types[i]);
            }
            if (index != this.types.length) {
                all = Arrays.copyOf(all, index);
            }
            return PrimitiveLongCollections.concat((LongIterator[])all);
        }

        @Override
        public RelationshipSelection reverse() {
            return Direction.BOTH.equals((Object)this.direction) ? this : new DirectionalMultipleTypes(this.types, this.direction.reverse(), this.highestType);
        }

        public String toString() {
            return "RelationshipSelection[types=" + Arrays.toString(this.types) + ", " + this.direction + "]";
        }

        private static boolean existsEarlier(int[] types, int i) {
            int candidateType = types[i];
            for (int j = i - 1; j >= 0; --j) {
                if (candidateType != types[j]) continue;
                return true;
            }
            return false;
        }
    }

    private static class DirectionalAllTypes
    extends DirectionalSingleCriterion {
        DirectionalAllTypes(Direction direction) {
            super(-1, direction);
        }

        @Override
        public boolean test(int type) {
            return true;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return direction.matches(this.direction);
        }

        @Override
        public boolean isTypeLimited() {
            return false;
        }

        @Override
        public int highestType() {
            return Integer.MAX_VALUE;
        }

        @Override
        public LongIterator addedRelationships(NodeState transactionState) {
            return transactionState.getAddedRelationships(this.direction);
        }

        @Override
        public RelationshipSelection reverse() {
            return Direction.BOTH.equals((Object)this.direction) ? this : new DirectionalAllTypes(this.direction.reverse());
        }

        public String toString() {
            return "RelationshipSelection[" + this.direction + "]";
        }
    }

    private static class MultiDirectionalMultiType
    extends Directional {
        private final DirectedTypes directedTypes;

        MultiDirectionalMultiType(DirectedTypes directedTypes) {
            super(directedTypes.computeDirection());
            this.directedTypes = directedTypes;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return super.test(direction);
        }

        @Override
        public boolean test(int type) {
            return this.directedTypes.hasEither(type);
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            if (direction == RelationshipDirection.LOOP) {
                return this.test(type);
            }
            if (direction == RelationshipDirection.OUTGOING) {
                return this.directedTypes.hasOutgoing(type);
            }
            return this.directedTypes.hasIncoming(type);
        }

        @Override
        public int numberOfCriteria() {
            return this.directedTypes.numberOfCriteria();
        }

        @Override
        public boolean isTypeLimited() {
            return this.directedTypes.isTypeLimited();
        }

        @Override
        public Direction criterionDirection(int index) {
            return this.directedTypes.criterionDirection(index);
        }

        @Override
        public int criterionType(int index) {
            return this.directedTypes.criterionType(index);
        }

        @Override
        public int highestType() {
            return this.directedTypes.isTypeLimited() ? this.directedTypes.criterionType(this.directedTypes.numberOfCriteria() - 1) : Integer.MAX_VALUE;
        }

        @Override
        public LongIterator addedRelationships(NodeState transactionState) {
            return this.directedTypes.addedRelationships(transactionState);
        }

        @Override
        public RelationshipSelection reverse() {
            return new MultiDirectionalMultiType(this.directedTypes.reverse());
        }

        @Override
        public Direction direction(int type) {
            return this.directedTypes.direction(type);
        }

        public String toString() {
            return String.format("RelationshipSelection[%s]", this.directedTypes);
        }
    }

    private static abstract class DirectionalSingleCriterion
    extends Directional {
        protected final int type;

        DirectionalSingleCriterion(int type, Direction direction) {
            super(direction);
            this.type = type;
        }

        @Override
        public int numberOfCriteria() {
            return 1;
        }

        @Override
        public Direction criterionDirection(int index) {
            assert (index == 0);
            return this.direction;
        }

        @Override
        public int criterionType(int index) {
            assert (index == 0);
            return this.type;
        }

        @Override
        public int highestType() {
            return this.type;
        }
    }

    private static abstract class Directional
    extends RelationshipSelection {
        protected final Direction direction;

        Directional(Direction direction) {
            this.direction = direction;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return direction.matches(this.direction);
        }

        @Override
        public Direction direction(int type) {
            return this.direction;
        }
    }
}

