/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Locale;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PrivilegeAction {
    ACCESS,
    TRAVERSE,
    READ,
    SET_LABEL,
    REMOVE_LABEL,
    CREATE_ELEMENT,
    DELETE_ELEMENT,
    SET_PROPERTY,
    CREATE_LABEL,
    CREATE_RELTYPE,
    CREATE_PROPERTYKEY,
    CREATE_INDEX,
    DROP_INDEX,
    SHOW_INDEX,
    CREATE_CONSTRAINT,
    DROP_CONSTRAINT,
    SHOW_CONSTRAINT,
    START_DATABASE,
    STOP_DATABASE,
    SHOW_TRANSACTION,
    TERMINATE_TRANSACTION,
    SHOW_CONNECTION,
    TERMINATE_CONNECTION,
    CREATE_DATABASE,
    DROP_DATABASE,
    SET_DATABASE_ACCESS,
    CREATE_COMPOSITE_DATABASE,
    DROP_COMPOSITE_DATABASE,
    CREATE_ALIAS,
    DROP_ALIAS,
    ALTER_ALIAS,
    SHOW_ALIAS,
    SHOW_USER,
    CREATE_USER,
    RENAME_USER,
    SET_USER_STATUS,
    SET_PASSWORDS,
    SET_USER_HOME_DATABASE,
    DROP_USER,
    IMPERSONATE,
    SHOW_ROLE,
    CREATE_ROLE,
    RENAME_ROLE,
    DROP_ROLE,
    ASSIGN_ROLE,
    REMOVE_ROLE,
    SHOW_PRIVILEGE,
    ASSIGN_PRIVILEGE,
    REMOVE_PRIVILEGE,
    ASSIGN_IMMUTABLE_PRIVILEGE,
    REMOVE_IMMUTABLE_PRIVILEGE,
    EXECUTE,
    EXECUTE_BOOSTED,
    EXECUTE_ADMIN,
    SHOW_SERVER,
    SHOW_SETTING,
    ADMIN{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return DBMS_ACTIONS.satisfies(action) || TRANSACTION_MANAGEMENT.satisfies(action) || START_DATABASE.satisfies(action) || STOP_DATABASE.satisfies(action) || this == action;
        }
    }
    ,
    TOKEN{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case CREATE_LABEL, CREATE_RELTYPE, CREATE_PROPERTYKEY -> true;
                default -> this == action;
            };
        }
    }
    ,
    CONSTRAINT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case CREATE_CONSTRAINT, DROP_CONSTRAINT, SHOW_CONSTRAINT -> true;
                default -> this == action;
            };
        }
    }
    ,
    INDEX{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case CREATE_INDEX, DROP_INDEX, SHOW_INDEX -> true;
                default -> this == action;
            };
        }
    }
    ,
    COMPOSITE_DATABASE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case CREATE_COMPOSITE_DATABASE, DROP_COMPOSITE_DATABASE -> true;
                default -> this == action;
            };
        }
    }
    ,
    DATABASE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case CREATE_DATABASE, DROP_DATABASE -> true;
                default -> ALTER_DATABASE.satisfies(action) || COMPOSITE_DATABASE_MANAGEMENT.satisfies(action) || this == action;
            };
        }
    }
    ,
    ALTER_DATABASE{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            if (Objects.requireNonNull(action) == SET_DATABASE_ACCESS) {
                return true;
            }
            return this == action;
        }
    }
    ,
    ALIAS_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case CREATE_ALIAS, DROP_ALIAS, ALTER_ALIAS, SHOW_ALIAS -> true;
                default -> this == action;
            };
        }
    }
    ,
    TRANSACTION_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case SHOW_TRANSACTION, TERMINATE_TRANSACTION, SHOW_CONNECTION, TERMINATE_CONNECTION -> true;
                default -> this == action;
            };
        }
    }
    ,
    USER_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case SHOW_USER, CREATE_USER, RENAME_USER, DROP_USER -> true;
                default -> ALTER_USER.satisfies(action) || this == action;
            };
        }
    }
    ,
    ALTER_USER{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case SET_USER_STATUS, SET_PASSWORDS, SET_USER_HOME_DATABASE -> true;
                default -> this == action;
            };
        }
    }
    ,
    ROLE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case SHOW_ROLE, CREATE_ROLE, RENAME_ROLE, DROP_ROLE, ASSIGN_ROLE, REMOVE_ROLE -> true;
                default -> this == action;
            };
        }
    }
    ,
    PRIVILEGE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case SHOW_PRIVILEGE, ASSIGN_PRIVILEGE, REMOVE_PRIVILEGE -> true;
                default -> this == action;
            };
        }
    }
    ,
    MATCH{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case READ, TRAVERSE -> true;
                default -> this == action;
            };
        }
    }
    ,
    WRITE{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case SET_LABEL, REMOVE_LABEL, CREATE_ELEMENT, DELETE_ELEMENT, SET_PROPERTY -> true;
                default -> this == action;
            };
        }
    }
    ,
    MERGE{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case READ, TRAVERSE, CREATE_ELEMENT, SET_PROPERTY, MATCH -> true;
                default -> this == action;
            };
        }
    }
    ,
    GRAPH_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return switch (action) {
                case READ, TRAVERSE, MATCH -> true;
                default -> WRITE.satisfies(action) || this == action;
            };
        }
    }
    ,
    DATABASE_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return action == ACCESS || INDEX.satisfies(action) || CONSTRAINT.satisfies(action) || TOKEN.satisfies(action) || this == action;
        }
    }
    ,
    DBMS_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return ROLE_MANAGEMENT.satisfies(action) || USER_MANAGEMENT.satisfies(action) || DATABASE_MANAGEMENT.satisfies(action) || ALIAS_MANAGEMENT.satisfies(action) || PRIVILEGE_MANAGEMENT.satisfies(action) || EXECUTE_ADMIN == action || IMPERSONATE == action || SERVER_MANAGEMENT.satisfies(action) || this == action;
        }
    }
    ,
    SERVER_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return SHOW_SERVER.satisfies(action) || this == action;
        }
    };


    public boolean satisfies(PrivilegeAction action) {
        return this == action;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    public static PrivilegeAction from(String name) {
        try {
            return PrivilegeAction.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

