/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collection;
import java.util.Map;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public interface IndexPopulator
extends MinimalIndexAccessor {
    public static final IndexPopulator EMPTY = new Adapter();

    public void create();

    public void add(Collection<? extends IndexEntryUpdate<?>> var1, PageCursorTracer var2) throws IndexEntryConflictException;

    public void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor var1, PageCursorTracer var2);

    public void close(boolean var1, PageCursorTracer var2);

    public void markAsFailed(String var1);

    public void includeSample(IndexEntryUpdate<?> var1);

    public IndexSample sample(PageCursorTracer var1);

    default public PopulationProgress progress(PopulationProgress scanProgress) {
        return scanProgress;
    }

    default public void scanCompleted(PhaseTracker phaseTracker, JobScheduler jobScheduler, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
    }

    public static class Delegating
    implements IndexPopulator {
        private final IndexPopulator delegate;

        public Delegating(IndexPopulator delegate) {
            this.delegate = delegate;
        }

        @Override
        public void create() {
            this.delegate.create();
        }

        @Override
        public void drop() {
            this.delegate.drop();
        }

        @Override
        public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
            this.delegate.add(updates, cursorTracer);
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            this.delegate.verifyDeferredConstraints(nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, PageCursorTracer cursorTracer) {
            return this.delegate.newPopulatingUpdater(accessor, cursorTracer);
        }

        @Override
        public void close(boolean populationCompletedSuccessfully, PageCursorTracer cursorTracer) {
            this.delegate.close(populationCompletedSuccessfully, cursorTracer);
        }

        @Override
        public void markAsFailed(String failure) {
            this.delegate.markAsFailed(failure);
        }

        @Override
        public void includeSample(IndexEntryUpdate<?> update) {
            this.delegate.includeSample(update);
        }

        @Override
        public IndexSample sample(PageCursorTracer cursorTracer) {
            return this.delegate.sample(cursorTracer);
        }

        @Override
        public PopulationProgress progress(PopulationProgress scanProgress) {
            return this.delegate.progress(scanProgress);
        }

        @Override
        public void scanCompleted(PhaseTracker phaseTracker, JobScheduler jobScheduler, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
            this.delegate.scanCompleted(phaseTracker, jobScheduler, cursorTracer);
        }

        @Override
        public Map<String, Value> indexConfig() {
            return this.delegate.indexConfig();
        }
    }

    public static class Adapter
    implements IndexPopulator {
        @Override
        public void create() {
        }

        @Override
        public void drop() {
        }

        @Override
        public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) {
        }

        @Override
        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, PageCursorTracer cursorTracer) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void scanCompleted(PhaseTracker phaseTracker, JobScheduler jobScheduler, PageCursorTracer cursorTracer) {
        }

        @Override
        public void close(boolean populationCompletedSuccessfully, PageCursorTracer cursorTracer) {
        }

        @Override
        public void markAsFailed(String failure) {
        }

        @Override
        public void includeSample(IndexEntryUpdate<?> update) {
        }

        @Override
        public IndexSample sample(PageCursorTracer cursorTracer) {
            return new IndexSample();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
        }
    }
}

