/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionIterator;
import org.neo4j.io.IOUtils;

public final class RelationshipSelections {
    static final long UNINITIALIZED = -2L;
    static final long NO_ID = -1L;

    private RelationshipSelections() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static RelationshipSelectionCursor outgoingCursor(CursorFactory cursors, NodeCursor node, int[] types) {
        if (node.isDense()) {
            return RelationshipSelections.outgoingDenseCursor(cursors.allocateRelationshipGroupCursor(), cursors.allocateRelationshipTraversalCursor(), node, types);
        }
        return RelationshipSelections.outgoingSparseCursor(cursors.allocateRelationshipTraversalCursor(), node, types);
    }

    public static RelationshipSelectionCursor outgoingCursor(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        if (node.isDense()) {
            return RelationshipSelections.outgoingDenseCursor(groupCursor, traversalCursor, node, types);
        }
        return RelationshipSelections.outgoingSparseCursor(traversalCursor, node, types);
    }

    public static RelationshipSelectionCursor outgoingSparseCursor(RelationshipTraversalCursor traversal, NodeCursor node, int[] types) {
        assert (!node.isDense());
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        try {
            RelationshipSelections.setupOutgoingSparse(selectionCursor, traversal, node, types);
        }
        catch (Throwable t) {
            traversal.close();
            throw t;
        }
        return selectionCursor;
    }

    public static RelationshipSelectionCursor outgoingDenseCursor(RelationshipGroupCursor group, RelationshipTraversalCursor traversal, NodeCursor node, int[] types) {
        assert (node.isDense());
        RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
        try {
            RelationshipSelections.setupOutgoingDense(selectionCursor, group, traversal, node, types);
        }
        catch (Throwable t) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new Cursor[]{group, traversal});
            throw t;
        }
        return selectionCursor;
    }

    public static RelationshipSelectionCursor incomingCursor(CursorFactory cursors, NodeCursor node, int[] types) {
        if (node.isDense()) {
            return RelationshipSelections.incomingDenseCursor(cursors.allocateRelationshipGroupCursor(), cursors.allocateRelationshipTraversalCursor(), node, types);
        }
        return RelationshipSelections.incomingSparseCursor(cursors.allocateRelationshipTraversalCursor(), node, types);
    }

    public static RelationshipSelectionCursor incomingCursor(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        if (node.isDense()) {
            return RelationshipSelections.incomingDenseCursor(groupCursor, traversalCursor, node, types);
        }
        return RelationshipSelections.incomingSparseCursor(traversalCursor, node, types);
    }

    public static RelationshipSelectionCursor incomingSparseCursor(RelationshipTraversalCursor traversal, NodeCursor node, int[] types) {
        assert (!node.isDense());
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        try {
            RelationshipSelections.setupIncomingSparse(selectionCursor, traversal, node, types);
        }
        catch (Throwable t) {
            traversal.close();
            throw t;
        }
        return selectionCursor;
    }

    public static RelationshipSelectionCursor incomingDenseCursor(RelationshipGroupCursor group, RelationshipTraversalCursor traversal, NodeCursor node, int[] types) {
        assert (node.isDense());
        RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
        try {
            RelationshipSelections.setupIncomingDense(selectionCursor, group, traversal, node, types);
        }
        catch (Throwable t) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new Cursor[]{group, traversal});
            throw t;
        }
        return selectionCursor;
    }

    public static RelationshipSelectionCursor allCursor(CursorFactory cursors, NodeCursor node, int[] types) {
        if (node.isDense()) {
            return RelationshipSelections.allDenseCursor(cursors.allocateRelationshipGroupCursor(), cursors.allocateRelationshipTraversalCursor(), node, types);
        }
        return RelationshipSelections.allSparseCursor(cursors.allocateRelationshipTraversalCursor(), node, types);
    }

    public static RelationshipSelectionCursor allCursor(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        if (node.isDense()) {
            return RelationshipSelections.allDenseCursor(groupCursor, traversalCursor, node, types);
        }
        return RelationshipSelections.allSparseCursor(traversalCursor, node, types);
    }

    public static RelationshipSelectionCursor allSparseCursor(RelationshipTraversalCursor traversal, NodeCursor node, int[] types) {
        assert (!node.isDense());
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        try {
            RelationshipSelections.setupAllSparse(selectionCursor, traversal, node, types);
        }
        catch (Throwable t) {
            traversal.close();
            throw t;
        }
        return selectionCursor;
    }

    public static RelationshipSelectionCursor allDenseCursor(RelationshipGroupCursor group, RelationshipTraversalCursor traversal, NodeCursor node, int[] types) {
        assert (node.isDense());
        RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
        try {
            RelationshipSelections.setupAllDense(selectionCursor, group, traversal, node, types);
        }
        catch (Throwable t) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new Cursor[]{group, traversal});
            throw t;
        }
        return selectionCursor;
    }

    public static <T> ResourceIterator<T> outgoingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();
            RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();
            try {
                RelationshipSelections.setupOutgoingDense(selectionIterator, group, traversal, node, types);
            }
            catch (Throwable t) {
                IOUtils.closeAllUnchecked((AutoCloseable[])new Cursor[]{group, traversal});
                throw t;
            }
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();
        try {
            RelationshipSelections.setupOutgoingSparse(selectionIterator, traversal, node, types);
        }
        catch (Throwable t) {
            traversal.close();
            throw t;
        }
        return selectionIterator;
    }

    public static <T> ResourceIterator<T> incomingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();
            RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();
            try {
                RelationshipSelections.setupIncomingDense(selectionIterator, group, traversal, node, types);
            }
            catch (Throwable t) {
                IOUtils.closeAllUnchecked((AutoCloseable[])new Cursor[]{group, traversal});
                throw t;
            }
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();
        try {
            RelationshipSelections.setupIncomingSparse(selectionIterator, traversal, node, types);
        }
        catch (Throwable t) {
            traversal.close();
            throw t;
        }
        return selectionIterator;
    }

    public static <T> ResourceIterator<T> allIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();
            RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();
            try {
                RelationshipSelections.setupAllDense(selectionIterator, group, traversal, node, types);
            }
            catch (Throwable t) {
                IOUtils.closeAllUnchecked((AutoCloseable[])new Cursor[]{group, traversal});
                throw t;
            }
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();
        try {
            RelationshipSelections.setupAllSparse(selectionIterator, traversal, node, types);
        }
        catch (Throwable t) {
            traversal.close();
            throw t;
        }
        return selectionIterator;
    }

    private static void setupOutgoingDense(RelationshipDenseSelection denseSelection, RelationshipGroupCursor groupCursor, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.relationships(groupCursor);
        denseSelection.outgoing(groupCursor, traversalCursor, types);
    }

    private static void setupIncomingDense(RelationshipDenseSelection denseSelection, RelationshipGroupCursor groupCursor, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.relationships(groupCursor);
        denseSelection.incoming(groupCursor, traversalCursor, types);
    }

    private static void setupAllDense(RelationshipDenseSelection denseSelection, RelationshipGroupCursor groupCursor, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.relationships(groupCursor);
        denseSelection.all(groupCursor, traversalCursor, types);
    }

    private static void setupOutgoingSparse(RelationshipSparseSelection sparseSelection, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.allRelationships(traversalCursor);
        sparseSelection.outgoing(traversalCursor, types);
    }

    private static void setupIncomingSparse(RelationshipSparseSelection sparseSelection, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.allRelationships(traversalCursor);
        sparseSelection.incoming(traversalCursor, types);
    }

    private static void setupAllSparse(RelationshipSparseSelection sparseSelection, RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.allRelationships(traversalCursor);
        sparseSelection.all(traversalCursor, types);
    }
}

