/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;

public final class RelationshipDenseSelectionCursor
extends RelationshipDenseSelection
implements RelationshipSelectionCursor {
    @Override
    public boolean next() {
        if (!this.fetchNext()) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public long relationshipReference() {
        return this.relationshipCursor.relationshipReference();
    }

    @Override
    public int type() {
        return this.relationshipCursor.type();
    }

    @Override
    public long otherNodeReference() {
        return this.relationshipCursor.originNodeReference() == this.relationshipCursor.sourceNodeReference() ? this.relationshipCursor.targetNodeReference() : this.relationshipCursor.sourceNodeReference();
    }

    @Override
    public long sourceNodeReference() {
        return this.relationshipCursor.sourceNodeReference();
    }

    @Override
    public long targetNodeReference() {
        return this.relationshipCursor.targetNodeReference();
    }

    @Override
    public long propertiesReference() {
        return this.relationshipCursor.propertiesReference();
    }

    @Override
    public boolean isClosed() {
        return this.relationshipCursor == null || this.relationshipCursor.isClosed();
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        this.groupCursor.setTracer(tracer);
        this.relationshipCursor.setTracer(tracer);
    }

    public RelationshipGroupCursor groupCursor() {
        return this.groupCursor;
    }

    public RelationshipTraversalCursor traversalCursor() {
        return this.relationshipCursor;
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipDenseSelectionCursor[closed state]";
        }
        return "RelationshipDenseSelectionCursor[relCursor=" + this.relationshipCursor.toString() + "]";
    }

    @Override
    public void close() {
        this.closeInternal();
        CloseListener listener = this.closeListener;
        if (listener != null) {
            listener.onClosed(this);
        }
    }
}

