/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Optional;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;

public interface Transaction
extends AutoCloseable {
    public static final long ROLLBACK = -1L;
    public static final long READ_ONLY = 0L;

    public void success();

    public void failure();

    public Read dataRead();

    public Write dataWrite() throws InvalidTransactionTypeKernelException;

    public ExplicitIndexRead indexRead();

    public ExplicitIndexWrite indexWrite() throws InvalidTransactionTypeKernelException;

    public TokenRead tokenRead();

    public TokenWrite tokenWrite();

    public Token token();

    public SchemaRead schemaRead();

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException;

    public Locks locks();

    public CursorFactory cursors();

    public Procedures procedures();

    public ExecutionStatistics executionStatistics();

    public long closeTransaction() throws TransactionFailureException;

    @Override
    default public void close() throws TransactionFailureException {
        this.closeTransaction();
    }

    public boolean isOpen();

    public Optional<Status> getReasonIfTerminated();

    public boolean isTerminated();

    public void markForTermination(Status var1);

    public static enum Type {
        implicit,
        explicit;

    }
}

