/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import java.util.Optional;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;

public class IndexDescriptorFactory {
    private IndexDescriptorFactory() {
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema) {
        return IndexDescriptorFactory.forSchema(schema, IndexProviderDescriptor.UNDECIDED);
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema, IndexProviderDescriptor providerDescriptor) {
        return IndexDescriptorFactory.forSchema(schema, Optional.empty(), providerDescriptor);
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema, Optional<String> name, IndexProviderDescriptor providerDescriptor) {
        return new IndexDescriptor(schema, IndexDescriptor.Type.GENERAL, name, providerDescriptor);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return IndexDescriptorFactory.uniqueForSchema(schema, IndexProviderDescriptor.UNDECIDED);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema, IndexProviderDescriptor providerDescriptor) {
        return IndexDescriptorFactory.uniqueForSchema(schema, Optional.empty(), providerDescriptor);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema, Optional<String> name, IndexProviderDescriptor providerDescriptor) {
        return new IndexDescriptor(schema, IndexDescriptor.Type.UNIQUE, name, providerDescriptor);
    }
}

