/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Collections;
import java.util.List;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;

public class StubRelationshipCursor
implements RelationshipTraversalCursor {
    private final List<TestRelationshipChain> store;
    private int offset;
    private int chainId;
    private boolean isClosed;

    public StubRelationshipCursor(TestRelationshipChain chain) {
        this(Collections.singletonList(chain));
    }

    StubRelationshipCursor(List<TestRelationshipChain> store) {
        this.store = store;
        this.chainId = 0;
        this.offset = -1;
        this.isClosed = true;
    }

    void rewind() {
        this.offset = -1;
        this.isClosed = true;
    }

    void read(int chainId) {
        this.chainId = chainId;
        this.rewind();
    }

    public long relationshipReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).id;
    }

    public int type() {
        return this.store.get((int)this.chainId).get((int)this.offset).type;
    }

    public boolean hasProperties() {
        return false;
    }

    public void source(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void target(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void properties(PropertyCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long sourceNodeReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).source;
    }

    public long targetNodeReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).target;
    }

    public long propertiesReference() {
        return -1L;
    }

    public RelationshipTraversalCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipTraversalCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void neighbour(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long neighbourNodeReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long originNodeReference() {
        return this.store.get(this.chainId).originNodeId();
    }

    public boolean next() {
        ++this.offset;
        return this.store.get(this.chainId).isValidOffset(this.offset);
    }

    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

