/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;

class StubGroupCursor
implements RelationshipGroupCursor {
    private int offset;
    private final GroupData[] groups;
    private boolean isClosed;

    StubGroupCursor(GroupData ... groups) {
        this.groups = groups;
        this.offset = -1;
        this.isClosed = false;
    }

    void rewind() {
        this.offset = -1;
        this.isClosed = false;
    }

    public RelationshipGroupCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipGroupCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        ++this.offset;
        return this.offset >= 0 && this.offset < this.groups.length;
    }

    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int type() {
        return this.groups[this.offset].type;
    }

    public int outgoingCount() {
        return this.groups[this.offset].countOut;
    }

    public int incomingCount() {
        return this.groups[this.offset].countIn;
    }

    public int loopCount() {
        return this.groups[this.offset].countLoop;
    }

    public void outgoing(RelationshipTraversalCursor cursor) {
        ((StubRelationshipCursor)cursor).read(this.groups[this.offset].out);
    }

    public void incoming(RelationshipTraversalCursor cursor) {
        ((StubRelationshipCursor)cursor).read(this.groups[this.offset].in);
    }

    public void loops(RelationshipTraversalCursor cursor) {
        ((StubRelationshipCursor)cursor).read(this.groups[this.offset].loop);
    }

    public long outgoingReference() {
        return this.groups[this.offset].out;
    }

    public long incomingReference() {
        return this.groups[this.offset].in;
    }

    public long loopsReference() {
        return this.groups[this.offset].loop;
    }

    static class GroupData {
        final int out;
        final int in;
        final int loop;
        final int type;
        int countIn;
        int countOut;
        int countLoop;

        GroupData(int out, int in, int loop, int type) {
            this.out = out;
            this.in = in;
            this.loop = loop;
            this.type = type;
        }

        GroupData withOutCount(int count) {
            this.countOut = count;
            return this;
        }

        GroupData withInCount(int count) {
            this.countIn = count;
            return this;
        }

        GroupData withLoopCount(int count) {
            this.countLoop = count;
            return this;
        }
    }
}

