/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionTestBase;
import org.neo4j.internal.kernel.api.helpers.StubGroupCursor;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;

public abstract class RelationshipDenseSelectionTestBase<Traverser extends RelationshipDenseSelection>
extends RelationshipSelectionTestBase {
    private TestRelationshipChain outA = new TestRelationshipChain(42L);
    private TestRelationshipChain inA = new TestRelationshipChain(42L).incoming(0L, 1L, 100).incoming(0L, 2L, 100);
    private TestRelationshipChain loopA = new TestRelationshipChain(42L).loop(0L, 100);
    private TestRelationshipChain outB = new TestRelationshipChain(42L).outgoing(0L, 10L, 101);
    private TestRelationshipChain inB = new TestRelationshipChain(42L);
    private TestRelationshipChain loopB = new TestRelationshipChain(42L).loop(0L, 101).loop(0L, 101);
    private TestRelationshipChain outC = new TestRelationshipChain(42L).outgoing(0L, 20L, 102).outgoing(0L, 21L, 102);
    private TestRelationshipChain inC = new TestRelationshipChain(42L).incoming(0L, 22L, 102);
    private TestRelationshipChain loopC = new TestRelationshipChain(42L);
    private List<TestRelationshipChain> store = new ArrayList<TestRelationshipChain>();
    private StubGroupCursor innerGroupCursor = new StubGroupCursor(this.group(this.store, 100, this.outA, this.inA, this.loopA), this.group(this.store, 101, this.outB, this.inB, this.loopB), this.group(this.store, 102, this.outC, this.inC, this.loopC));
    private StubRelationshipCursor innerRelationshipCursor = new StubRelationshipCursor(this.store);

    @Before
    public void rewindCursor() {
        this.innerGroupCursor.rewind();
    }

    protected abstract Traverser make();

    @Test
    public void shouldSelectOutgoing() {
        Traverser traverser = this.make();
        traverser.outgoing((RelationshipGroupCursor)this.innerGroupCursor, (RelationshipTraversalCursor)this.innerRelationshipCursor);
        this.assertLoop(traverser, 100);
        this.assertOutgoing(traverser, 10, 101);
        this.assertLoop(traverser, 101);
        this.assertLoop(traverser, 101);
        this.assertOutgoing(traverser, 20, 102);
        this.assertOutgoing(traverser, 21, 102);
        this.assertEmptyAndClosed(traverser);
    }

    @Test
    public void shouldSelectIncoming() {
        Traverser traverser = this.make();
        traverser.incoming((RelationshipGroupCursor)this.innerGroupCursor, (RelationshipTraversalCursor)this.innerRelationshipCursor);
        this.assertIncoming(traverser, 1, 100);
        this.assertIncoming(traverser, 2, 100);
        this.assertLoop(traverser, 100);
        this.assertLoop(traverser, 101);
        this.assertLoop(traverser, 101);
        this.assertIncoming(traverser, 22, 102);
        this.assertEmptyAndClosed(traverser);
    }

    @Test
    public void shouldSelectAll() {
        Traverser traverser = this.make();
        traverser.all((RelationshipGroupCursor)this.innerGroupCursor, (RelationshipTraversalCursor)this.innerRelationshipCursor);
        this.assertIncoming(traverser, 1, 100);
        this.assertIncoming(traverser, 2, 100);
        this.assertLoop(traverser, 100);
        this.assertOutgoing(traverser, 10, 101);
        this.assertLoop(traverser, 101);
        this.assertLoop(traverser, 101);
        this.assertOutgoing(traverser, 20, 102);
        this.assertOutgoing(traverser, 21, 102);
        this.assertIncoming(traverser, 22, 102);
        this.assertEmptyAndClosed(traverser);
    }

    @Test
    public void shouldSelectOutgoingOfType() {
        Traverser traverser = this.make();
        traverser.outgoing((RelationshipGroupCursor)this.innerGroupCursor, (RelationshipTraversalCursor)this.innerRelationshipCursor, this.types(100, 102));
        this.assertLoop(traverser, 100);
        this.assertOutgoing(traverser, 20, 102);
        this.assertOutgoing(traverser, 21, 102);
        this.assertEmptyAndClosed(traverser);
    }

    @Test
    public void shouldSelectIncomingOfType() {
        Traverser traverser = this.make();
        traverser.incoming((RelationshipGroupCursor)this.innerGroupCursor, (RelationshipTraversalCursor)this.innerRelationshipCursor, this.types(100, 102));
        this.assertIncoming(traverser, 1, 100);
        this.assertIncoming(traverser, 2, 100);
        this.assertLoop(traverser, 100);
        this.assertIncoming(traverser, 22, 102);
        this.assertEmptyAndClosed(traverser);
    }

    @Test
    public void shouldSelectAllOfType() {
        Traverser traverser = this.make();
        traverser.all((RelationshipGroupCursor)this.innerGroupCursor, (RelationshipTraversalCursor)this.innerRelationshipCursor, this.types(100, 102));
        this.assertIncoming(traverser, 1, 100);
        this.assertIncoming(traverser, 2, 100);
        this.assertLoop(traverser, 100);
        this.assertOutgoing(traverser, 20, 102);
        this.assertOutgoing(traverser, 21, 102);
        this.assertIncoming(traverser, 22, 102);
        this.assertEmptyAndClosed(traverser);
    }

    abstract void assertOutgoing(Traverser var1, int var2, int var3);

    abstract void assertIncoming(Traverser var1, int var2, int var3);

    abstract void assertLoop(Traverser var1, int var2);

    abstract void assertEmpty(Traverser var1);

    private void assertEmptyAndClosed(Traverser traverser) {
        this.assertEmpty(traverser);
        Assert.assertTrue((String)"close group cursor", (boolean)this.innerGroupCursor.isClosed());
        Assert.assertTrue((String)"close traversal cursor", (boolean)this.innerRelationshipCursor.isClosed());
    }

    private StubGroupCursor.GroupData group(List<TestRelationshipChain> store, int type, TestRelationshipChain out, TestRelationshipChain in, TestRelationshipChain loop) {
        return new StubGroupCursor.GroupData(this.addToStore(store, out), this.addToStore(store, in), this.addToStore(store, loop), type);
    }

    private int addToStore(List<TestRelationshipChain> store, TestRelationshipChain chain) {
        int ref = store.size();
        store.add(chain);
        return ref;
    }

    public static class CursorTest
    extends RelationshipDenseSelectionTestBase<RelationshipDenseSelectionCursor> {
        @Override
        protected RelationshipDenseSelectionCursor make() {
            return new RelationshipDenseSelectionCursor();
        }

        @Override
        void assertOutgoing(RelationshipDenseSelectionCursor iterator, int targetNode, int type) {
            this.assertOutgoing(iterator, targetNode, type);
        }

        @Override
        void assertIncoming(RelationshipDenseSelectionCursor iterator, int sourceNode, int type) {
            this.assertIncoming(iterator, sourceNode, type);
        }

        @Override
        void assertLoop(RelationshipDenseSelectionCursor iterator, int type) {
            this.assertLoop(iterator, type);
        }

        @Override
        void assertEmpty(RelationshipDenseSelectionCursor iterator) {
            this.assertEmpty(iterator);
        }
    }

    public static class IteratorTest
    extends RelationshipDenseSelectionTestBase<RelationshipDenseSelectionIterator<RelationshipSelectionTestBase.R>> {
        @Override
        protected RelationshipDenseSelectionIterator<RelationshipSelectionTestBase.R> make() {
            return new RelationshipDenseSelectionIterator(RelationshipSelectionTestBase.R::new);
        }

        @Override
        void assertOutgoing(RelationshipDenseSelectionIterator<RelationshipSelectionTestBase.R> iterator, int targetNode, int type) {
            this.assertOutgoing(iterator, targetNode, type);
        }

        @Override
        void assertIncoming(RelationshipDenseSelectionIterator<RelationshipSelectionTestBase.R> iterator, int sourceNode, int type) {
            this.assertIncoming(iterator, sourceNode, type);
        }

        @Override
        void assertLoop(RelationshipDenseSelectionIterator<RelationshipSelectionTestBase.R> iterator, int type) {
            this.assertLoop(iterator, type);
        }

        @Override
        void assertEmpty(RelationshipDenseSelectionIterator<RelationshipSelectionTestBase.R> iterator) {
            this.assertEmpty(iterator);
        }
    }
}

