/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.internal.kernel.api.helpers.StubCursorFactory;
import org.neo4j.internal.kernel.api.helpers.StubGroupCursor;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;

public class NodesTest {
    @Test
    public void shouldCountOutgoingDense() {
        StubGroupCursor groupCursor = new StubGroupCursor(this.group().withOutCount(1).withInCount(1).withLoopCount(5), this.group().withOutCount(1).withInCount(1).withLoopCount(3), this.group().withOutCount(2).withInCount(1).withLoopCount(2), this.group().withOutCount(3).withInCount(1).withLoopCount(1), this.group().withOutCount(5).withInCount(1).withLoopCount(1));
        StubCursorFactory cursors = new StubCursorFactory().withGroupCursors(groupCursor);
        int count = Nodes.countOutgoing((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void shouldCountOutgoingSparse() {
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(new TestRelationshipChain(11L).outgoing(55L, 0L, 1).incoming(56L, 0L, 1).outgoing(57L, 0L, 1).loop(58L, 0));
        StubCursorFactory cursors = new StubCursorFactory().withRelationshipTraversalCursors(relationshipCursor);
        StubNodeCursor nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        int count = Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void shouldCountIncomingDense() {
        StubGroupCursor groupCursor = new StubGroupCursor(this.group().withOutCount(1).withInCount(1).withLoopCount(5), this.group().withOutCount(1).withInCount(1).withLoopCount(3), this.group().withOutCount(2).withInCount(1).withLoopCount(2), this.group().withOutCount(3).withInCount(1).withLoopCount(1), this.group().withOutCount(5).withInCount(1).withLoopCount(1));
        StubCursorFactory cursors = new StubCursorFactory().withGroupCursors(groupCursor);
        int count = Nodes.countIncoming((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)17));
    }

    @Test
    public void shouldCountIncomingSparse() {
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(new TestRelationshipChain(11L).outgoing(55L, 0L, 1).incoming(56L, 0L, 1).outgoing(57L, 0L, 1).loop(58L, 0));
        StubCursorFactory cursors = new StubCursorFactory().withRelationshipTraversalCursors(relationshipCursor);
        StubNodeCursor nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        int count = Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldCountAllDense() {
        StubGroupCursor groupCursor = new StubGroupCursor(this.group().withOutCount(1).withInCount(1).withLoopCount(5), this.group().withOutCount(1).withInCount(1).withLoopCount(3), this.group().withOutCount(2).withInCount(1).withLoopCount(2), this.group().withOutCount(3).withInCount(1).withLoopCount(1), this.group().withOutCount(5).withInCount(1).withLoopCount(1));
        StubCursorFactory cursors = new StubCursorFactory().withGroupCursors(groupCursor);
        int count = Nodes.countAll((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)29));
    }

    @Test
    public void shouldCountAllSparse() {
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(new TestRelationshipChain(11L).outgoing(55L, 0L, 1).incoming(56L, 0L, 1).outgoing(57L, 0L, 1).loop(58L, 0));
        StubCursorFactory cursors = new StubCursorFactory().withRelationshipTraversalCursors(relationshipCursor);
        StubNodeCursor nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        int count = Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void shouldCountOutgoingDenseWithType() {
        StubGroupCursor groupCursor = new StubGroupCursor(this.group(1).withOutCount(1).withInCount(1).withLoopCount(5), this.group(2).withOutCount(1).withInCount(1).withLoopCount(3));
        StubCursorFactory cursors = new StubCursorFactory().withGroupCursors(groupCursor, groupCursor);
        MatcherAssert.assertThat((Object)Nodes.countOutgoing((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors, (int)1), (Matcher)CoreMatchers.equalTo((Object)6));
        MatcherAssert.assertThat((Object)Nodes.countOutgoing((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors, (int)2), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void shouldCountOutgoingSparseWithType() {
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(new TestRelationshipChain(11L).outgoing(55L, 0L, 1).incoming(56L, 0L, 1).outgoing(57L, 0L, 1).loop(58L, 2));
        StubCursorFactory cursors = new StubCursorFactory(true).withRelationshipTraversalCursors(relationshipCursor);
        StubNodeCursor nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        MatcherAssert.assertThat((Object)Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)1), (Matcher)CoreMatchers.equalTo((Object)2));
        nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        MatcherAssert.assertThat((Object)Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)2), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldCountIncomingWithTypeDense() {
        StubGroupCursor groupCursor = new StubGroupCursor(this.group(1).withOutCount(1).withInCount(1).withLoopCount(5), this.group(2).withOutCount(1).withInCount(1).withLoopCount(3));
        StubCursorFactory cursors = new StubCursorFactory().withGroupCursors(groupCursor, groupCursor);
        MatcherAssert.assertThat((Object)Nodes.countIncoming((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors, (int)1), (Matcher)CoreMatchers.equalTo((Object)6));
        MatcherAssert.assertThat((Object)Nodes.countIncoming((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors, (int)2), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void shouldCountIncomingWithTypeSparse() {
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(new TestRelationshipChain(11L).outgoing(55L, 0L, 1).incoming(56L, 0L, 1).outgoing(57L, 0L, 1).loop(58L, 2));
        StubCursorFactory cursors = new StubCursorFactory(true).withRelationshipTraversalCursors(relationshipCursor);
        StubNodeCursor nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        MatcherAssert.assertThat((Object)Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)1), (Matcher)CoreMatchers.equalTo((Object)1));
        nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        MatcherAssert.assertThat((Object)Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)2), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldCountAllWithTypeDense() {
        StubGroupCursor groupCursor = new StubGroupCursor(this.group(1).withOutCount(1).withInCount(1).withLoopCount(5), this.group(2).withOutCount(1).withInCount(1).withLoopCount(3));
        StubCursorFactory cursors = new StubCursorFactory().withGroupCursors(groupCursor, groupCursor);
        MatcherAssert.assertThat((Object)Nodes.countAll((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors, (int)1), (Matcher)CoreMatchers.equalTo((Object)7));
        MatcherAssert.assertThat((Object)Nodes.countAll((NodeCursor)new StubNodeCursor(true), (CursorFactory)cursors, (int)2), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void shouldCountAllWithTypeSparse() {
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(new TestRelationshipChain(11L).outgoing(55L, 0L, 1).incoming(56L, 0L, 1).outgoing(57L, 0L, 1).loop(58L, 2));
        StubCursorFactory cursors = new StubCursorFactory(true).withRelationshipTraversalCursors(relationshipCursor);
        StubNodeCursor nodeCursor = new StubNodeCursor(false).withNode(11L);
        nodeCursor.next();
        MatcherAssert.assertThat((Object)Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)1), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)2), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private StubGroupCursor.GroupData group() {
        return new StubGroupCursor.GroupData(0, 0, 0, 0);
    }

    private StubGroupCursor.GroupData group(int type) {
        return new StubGroupCursor.GroupData(0, 0, 0, type);
    }
}

