/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.junit.Assert;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;

public class RelationshipTestSupport {
    private static Function<Node, StartRelationship>[] sparseDenseRels = (Function[])Iterators.array((Object[])new Function[]{RelationshipTestSupport.loop("FOO"), RelationshipTestSupport.outgoing("FOO"), RelationshipTestSupport.outgoing("BAR"), RelationshipTestSupport.outgoing("BAR"), RelationshipTestSupport.incoming("FOO"), RelationshipTestSupport.outgoing("FOO"), RelationshipTestSupport.incoming("BAZ"), RelationshipTestSupport.incoming("BAR"), RelationshipTestSupport.outgoing("BAZ"), RelationshipTestSupport.loop("FOO")});

    private RelationshipTestSupport() {
    }

    static void someGraph(GraphDatabaseService graphDb) {
        Relationship dead;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node a = graphDb.createNode();
            Node b = graphDb.createNode();
            Node c = graphDb.createNode();
            Node d = graphDb.createNode();
            a.createRelationshipTo(a, RelationshipType.withName((String)"ALPHA"));
            a.createRelationshipTo(b, RelationshipType.withName((String)"BETA"));
            a.createRelationshipTo(c, RelationshipType.withName((String)"GAMMA"));
            a.createRelationshipTo(d, RelationshipType.withName((String)"DELTA"));
            graphDb.createNode().createRelationshipTo(a, RelationshipType.withName((String)"BETA"));
            a.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BETA"));
            dead = a.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BETA"));
            a.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BETA"));
            Node clump = graphDb.createNode();
            clump.createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"REL"));
            graphDb.createNode().createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            graphDb.createNode().createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            graphDb.createNode().createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            tx.success();
        }
        tx = graphDb.beginTx();
        var3_2 = null;
        try {
            Node node = dead.getEndNode();
            dead.delete();
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    static StartNode sparse(GraphDatabaseService graphDb) {
        Map<String, List<StartRelationship>> relationshipMap;
        Node node;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            node = graphDb.createNode();
            relationshipMap = RelationshipTestSupport.buildSparseDenseRels(node);
            tx.success();
        }
        return new StartNode(node.getId(), relationshipMap);
    }

    static StartNode dense(GraphDatabaseService graphDb) {
        Map<String, List<StartRelationship>> relationshipMap;
        Node node;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            node = graphDb.createNode();
            relationshipMap = RelationshipTestSupport.buildSparseDenseRels(node);
            ArrayList<StartRelationship> bulk = new ArrayList<StartRelationship>();
            RelationshipType bulkType = RelationshipType.withName((String)"BULK");
            for (int i = 0; i < 200; ++i) {
                Relationship r = node.createRelationshipTo(graphDb.createNode(), bulkType);
                bulk.add(new StartRelationship(r.getId(), Direction.OUTGOING, bulkType));
            }
            String bulkKey = RelationshipTestSupport.computeKey("BULK", Direction.OUTGOING);
            relationshipMap.put(bulkKey, bulk);
            tx.success();
        }
        return new StartNode(node.getId(), relationshipMap);
    }

    static Map<String, Integer> count(Transaction transaction, RelationshipTraversalCursor relationship) throws KernelException {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        while (relationship.next()) {
            String key = RelationshipTestSupport.computeKey(transaction, relationship);
            counts.compute(key, (k, value) -> value == null ? 1 : value + 1);
        }
        return counts;
    }

    static void assertCount(Transaction transaction, RelationshipTraversalCursor relationship, Map<String, Integer> expectedCounts, int expectedType, Direction direction) throws KernelException {
        String key = RelationshipTestSupport.computeKey(transaction.token().relationshipTypeName(expectedType), direction);
        int expectedCount = expectedCounts.getOrDefault(key, 0);
        int count = 0;
        while (relationship.next()) {
            Assert.assertEquals((String)"same type", (long)expectedType, (long)relationship.type());
            ++count;
        }
        Assert.assertEquals((String)String.format("expected number of relationships for key '%s'", key), (long)expectedCount, (long)count);
    }

    static void assertCounts(Map<String, Integer> expectedCounts, Map<String, Integer> counts) {
        for (Map.Entry<String, Integer> expected : expectedCounts.entrySet()) {
            Assert.assertEquals((String)String.format("counts for relationship key '%s' are equal", expected.getKey()), (Object)expected.getValue(), (Object)counts.get(expected.getKey()));
        }
    }

    private static Map<String, List<StartRelationship>> buildSparseDenseRels(Node node) {
        HashMap<String, List<StartRelationship>> relationshipMap = new HashMap<String, List<StartRelationship>>();
        for (Function<Node, StartRelationship> rel : sparseDenseRels) {
            StartRelationship r = rel.apply(node);
            List relsOfType = relationshipMap.computeIfAbsent(RelationshipTestSupport.computeKey(r), key -> new ArrayList());
            relsOfType.add(r);
        }
        return relationshipMap;
    }

    private static String computeKey(StartRelationship r) {
        return RelationshipTestSupport.computeKey(r.type.name(), r.direction);
    }

    private static String computeKey(Transaction transaction, RelationshipTraversalCursor r) throws KernelException {
        Direction d = r.sourceNodeReference() == r.targetNodeReference() ? Direction.BOTH : (r.sourceNodeReference() == r.originNodeReference() ? Direction.OUTGOING : Direction.INCOMING);
        return RelationshipTestSupport.computeKey(transaction.token().relationshipTypeName(r.type()), d);
    }

    static String computeKey(String type, Direction direction) {
        return type + "-" + direction;
    }

    private static Function<Node, StartRelationship> outgoing(String type) {
        return node -> {
            GraphDatabaseService db = node.getGraphDatabase();
            RelationshipType relType = RelationshipType.withName((String)type);
            return new StartRelationship(node.createRelationshipTo(db.createNode(), relType).getId(), Direction.OUTGOING, relType);
        };
    }

    private static Function<Node, StartRelationship> incoming(String type) {
        return node -> {
            GraphDatabaseService db = node.getGraphDatabase();
            RelationshipType relType = RelationshipType.withName((String)type);
            return new StartRelationship(db.createNode().createRelationshipTo(node, relType).getId(), Direction.INCOMING, relType);
        };
    }

    private static Function<Node, StartRelationship> loop(String type) {
        return node -> {
            RelationshipType relType = RelationshipType.withName((String)type);
            return new StartRelationship(node.createRelationshipTo(node, relType).getId(), Direction.BOTH, relType);
        };
    }

    static class StartNode {
        public final long id;
        public final Map<String, List<StartRelationship>> relationships;

        StartNode(long id, Map<String, List<StartRelationship>> relationships) {
            this.id = id;
            this.relationships = relationships;
        }

        Map<String, Integer> expectedCounts() {
            HashMap<String, Integer> expectedCounts = new HashMap<String, Integer>();
            for (Map.Entry<String, List<StartRelationship>> kv : this.relationships.entrySet()) {
                expectedCounts.put(kv.getKey(), this.relationships.get(kv.getKey()).size());
            }
            return expectedCounts;
        }
    }

    static class StartRelationship {
        public final long id;
        public final Direction direction;
        public final RelationshipType type;

        StartRelationship(long id, Direction direction, RelationshipType type) {
            this.id = id;
            this.type = type;
            this.direction = direction;
        }
    }
}

