/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

public abstract class RandomRelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final int N_TRAVERSALS = 10000;
    private static int N_NODES = 100;
    private static int N_RELATIONSHIPS = 1000;
    private static long seed = new Random().nextInt();
    private static Random random = new Random(seed);
    private static List<Long> nodeIds = new ArrayList<Long>();

    @Override
    void createTestGraph(GraphDatabaseService graphDb) {
        int i;
        try (Transaction tx = graphDb.beginTx();){
            for (i = 0; i < N_NODES; ++i) {
                nodeIds.add(graphDb.createNode(new Label[]{Label.label((String)("LABEL" + i))}).getId());
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var3_3 = null;
        try {
            for (i = 0; i < N_RELATIONSHIPS; ++i) {
                Long source = nodeIds.get(random.nextInt(N_NODES));
                Long target = nodeIds.get(random.nextInt(N_NODES));
                graphDb.getNodeById(source.longValue()).createRelationshipTo(graphDb.getNodeById(target.longValue()), RelationshipType.withName((String)("REL" + i % 10)));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldManageRandomTraversals() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            for (int i = 0; i < 10000; ++i) {
                long nodeId = nodeIds.get(random.nextInt(N_NODES));
                this.read.singleNode(nodeId, node);
                Assert.assertTrue((String)"access root node", (boolean)node.next());
                node.relationships(group);
                Assert.assertFalse((String)"single root", (boolean)node.next());
                while (group.next()) {
                    group.incoming(relationship);
                    while (relationship.next()) {
                        Assert.assertEquals((String)"incoming origin", (long)nodeId, (long)relationship.originNodeReference());
                        relationship.neighbour(node);
                    }
                    group.outgoing(relationship);
                    while (relationship.next()) {
                        Assert.assertEquals((String)"outgoing origin", (long)nodeId, (long)relationship.originNodeReference());
                        relationship.neighbour(node);
                    }
                    group.loops(relationship);
                    while (relationship.next()) {
                        Assert.assertEquals((String)"loop origin", (long)nodeId, (long)relationship.originNodeReference());
                        relationship.neighbour(node);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed with random seed " + seed, t);
        }
    }
}

