/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

public abstract class NodeValueIndexCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long strOne;
    private static long strTwo1;
    private static long strTwo2;
    private static long strThree1;
    private static long strThree2;
    private static long strThree3;
    private static long boolTrue;
    private static long num5;
    private static long num6;
    private static long num12a;
    private static long num12b;
    private static long strOneNoLabel;
    private static long joeDalton;
    private static long williamDalton;
    private static long jackDalton;
    private static long averellDalton;
    private static long date891;
    private static long date892;
    private static long date86;
    private static final PointValue POINT_1;
    private static final PointValue POINT_2;

    @Override
    void createTestGraph(GraphDatabaseService graphDb) {
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop2").create();
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop3").create();
            tx.success();
        }
        try {
            tx = graphDb.beginTx();
            var3_4 = null;
            try {
                this.createCompositeIndex(graphDb, "Person", "firstname", "surname");
                tx.success();
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var3_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        tx = graphDb.beginTx();
        var3_4 = null;
        try {
            graphDb.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        var3_4 = null;
        try {
            strOne = this.nodeWithProp(graphDb, "one");
            strTwo1 = this.nodeWithProp(graphDb, "two");
            strTwo2 = this.nodeWithProp(graphDb, "two");
            strThree1 = this.nodeWithProp(graphDb, "three");
            strThree2 = this.nodeWithProp(graphDb, "three");
            strThree3 = this.nodeWithProp(graphDb, "three");
            this.nodeWithProp(graphDb, false);
            boolTrue = this.nodeWithProp(graphDb, true);
            this.nodeWithProp(graphDb, 3);
            this.nodeWithProp(graphDb, 3);
            this.nodeWithProp(graphDb, 3);
            this.nodeWithProp(graphDb, 2);
            this.nodeWithProp(graphDb, 2);
            this.nodeWithProp(graphDb, 1);
            this.nodeWithProp(graphDb, 4);
            num5 = this.nodeWithProp(graphDb, 5);
            num6 = this.nodeWithProp(graphDb, 6);
            num12a = this.nodeWithProp(graphDb, 12.0);
            num12b = this.nodeWithProp(graphDb, 12.0);
            this.nodeWithProp(graphDb, 18);
            this.nodeWithProp(graphDb, 24);
            this.nodeWithProp(graphDb, 30);
            this.nodeWithProp(graphDb, 36);
            this.nodeWithProp(graphDb, 42);
            strOneNoLabel = this.nodeWithNoLabel(graphDb, "one");
            joeDalton = this.person(graphDb, "Joe", "Dalton");
            williamDalton = this.person(graphDb, "William", "Dalton");
            jackDalton = this.person(graphDb, "Jack", "Dalton");
            averellDalton = this.person(graphDb, "Averell", "Dalton");
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 0.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 1.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{0.0, 0.0, 0.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(graphDb, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{0.0, 0.0, 0.0}));
            date891 = this.nodeWithProp(graphDb, DateValue.date((int)1989, (int)3, (int)24));
            date86 = this.nodeWithProp(graphDb, DateValue.date((int)1986, (int)11, (int)18));
            date892 = this.nodeWithProp(graphDb, DateValue.date((int)1989, (int)3, (int)24));
            this.assertSameDerivedValue(POINT_1, POINT_2);
            this.nodeWithProp(graphDb, "prop3", POINT_1.asObjectCopy());
            this.nodeWithProp(graphDb, "prop3", POINT_2.asObjectCopy());
            this.nodeWithProp(graphDb, "prop3", POINT_2.asObjectCopy());
            tx.success();
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    protected abstract void createCompositeIndex(GraphDatabaseService var1, String var2, String ... var3) throws Exception;

    protected abstract String providerKey();

    protected abstract String providerVersion();

    protected abstract boolean spatialRangeSupport();

    protected boolean distinctValuesSupport() {
        return true;
    }

    protected abstract void assertSameDerivedValue(PointValue var1, PointValue var2);

    @Test
    public void shouldPerformExactLookup() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"zero")});
            this.assertFoundNodesAndNoValue(node, uniqueIds, new long[0]);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            this.assertFoundNodesAndNoValue(node, uniqueIds, strOne);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"two")});
            this.assertFoundNodesAndNoValue(node, uniqueIds, strTwo1, strTwo2);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"three")});
            this.assertFoundNodesAndNoValue(node, uniqueIds, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)1)});
            this.assertFoundNodesAndNoValue(node, 1, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)2)});
            this.assertFoundNodesAndNoValue(node, 2, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)3)});
            this.assertFoundNodesAndNoValue(node, 3, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)6)});
            this.assertFoundNodesAndNoValue(node, uniqueIds, num6);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)12.0)});
            this.assertFoundNodesAndNoValue(node, uniqueIds, num12a, num12b);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)true)});
            this.assertFoundNodesAndNoValue(node, uniqueIds, boolTrue);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 3, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{0.0, 0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 1, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 1, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{0.0, 0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 1, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)DateValue.date((int)1989, (int)3, (int)24))});
            this.assertFoundNodesAndNoValue(node, 2, uniqueIds);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)DateValue.date((int)1986, (int)11, (int)18))});
            this.assertFoundNodesAndNoValue(node, 1, uniqueIds);
        }
    }

    @Test
    public void shouldPerformExactLookupInCompositeIndex() throws Exception {
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{firstName, surname});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            IndexValueCapability valueCapability = index.valueCapability(new ValueCategory[]{ValueCategory.TEXT, ValueCategory.TEXT});
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Joe"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)2));
            this.assertFoundNodesAndValue(node, uniqueIds, valueCapability, joeDalton);
        }
    }

    @Test
    public void shouldPerformStringPrefixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability stringCapability = index.valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (String)"t")});
            Assert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strTwo1, strTwo2, strThree1, strThree2, strThree3);
        }
    }

    @Test
    public void shouldPerformStringSuffixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability stringCapability = index.valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringSuffix((int)prop, (String)"e")});
            Assert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strOne, strThree1, strThree2, strThree3);
        }
    }

    @Test
    public void shouldPerformStringContainmentSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability stringCapability = index.valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringContains((int)prop, (String)"o")});
            Assert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strOne, strTwo1, strTwo2);
        }
    }

    @Test
    public void shouldPerformStringRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability stringCapability = index.valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strOne, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)false)});
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strOne);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)false, (String)"three", (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)false, (String)"two", (boolean)false)});
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, stringCapability, strOne, strThree1, strThree2, strThree3, strTwo1, strTwo2);
        }
    }

    @Test
    public void shouldPerformNumericRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability numberCapability = index.valueCapability(new ValueCategory[]{ValueCategory.NUMBER});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)true, (Number)12, (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, numberCapability, num5, num6, num12a, num12b);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)true, (Number)12, (boolean)false)});
            this.assertFoundNodesAndValue(node, uniqueIds, numberCapability, num5, num6);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)false, (Number)12, (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, numberCapability, num6, num12a, num12b);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)false, (Number)12, (boolean)false)});
            this.assertFoundNodesAndValue(node, uniqueIds, numberCapability, num6);
        }
    }

    @Test
    public void shouldPerformTemporalRangeSearch() throws KernelException {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability temporalCapability = index.valueCapability(new ValueCategory[]{ValueCategory.TEMPORAL});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, temporalCapability, date86, date891, date892);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)false)});
            this.assertFoundNodesAndValue(node, uniqueIds, temporalCapability, date86);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)false, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
            this.assertFoundNodesAndValue(node, uniqueIds, temporalCapability, date891, date892);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)false, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)false)});
            this.assertFoundNodesAndValue(node, uniqueIds, temporalCapability, new long[0]);
        }
    }

    @Test
    public void shouldPerformSpatialRangeSearch() throws KernelException {
        Assume.assumeTrue((boolean)this.spatialRangeSupport());
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability spatialCapability = index.valueCapability(new ValueCategory[]{ValueCategory.GEOMETRY});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian)});
            this.assertFoundNodesAndValue(node, 5, uniqueIds, spatialCapability);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D)});
            this.assertFoundNodesAndValue(node, 1, uniqueIds, spatialCapability);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84)});
            this.assertFoundNodesAndValue(node, 1, uniqueIds, spatialCapability);
            this.read.nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D)});
            this.assertFoundNodesAndValue(node, 1, uniqueIds, spatialCapability);
        }
    }

    @Test
    public void shouldPerformIndexScan() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability wildcardCapability = index.valueCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            this.read.nodeIndexScan((IndexReference)index, node, IndexOrder.NONE);
            Assert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, 35, uniqueIds, wildcardCapability);
        }
    }

    @Test
    public void shouldRespectOrderCapabilitiesForNumbers() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexOrder[] orderCapabilities = index.orderCapability(new ValueCategory[]{ValueCategory.NUMBER});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek((IndexReference)index, node, orderCapability, new IndexQuery[]{IndexQuery.range((int)prop, (Number)1, (boolean)true, (Number)42, (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    public void shouldRespectOrderCapabilitiesForStrings() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexOrder[] orderCapabilities = index.orderCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek((IndexReference)index, node, orderCapability, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    public void shouldRespectOrderCapabilitiesForTemporal() throws KernelException {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexOrder[] orderCapabilities = index.orderCapability(new ValueCategory[]{ValueCategory.TEMPORAL});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek((IndexReference)index, node, orderCapability, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    public void shouldRespectOrderCapabilitiesForSpatial() throws KernelException {
        Assume.assumeTrue((boolean)this.spatialRangeSupport());
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexOrder[] orderCapabilities = index.orderCapability(new ValueCategory[]{ValueCategory.GEOMETRY});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek((IndexReference)index, node, orderCapability, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    public void shouldRespectOrderCapabilitiesForWildcard() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexOrder[] orderCapabilities = index.orderCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek((IndexReference)index, node, orderCapability, new IndexQuery[]{IndexQuery.exists((int)prop)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    private void assertFoundNodesInOrder(NodeValueIndexCursor node, IndexOrder indexOrder) {
        Value currentValue = null;
        while (node.next()) {
            long nodeReference = node.nodeReference();
            Value storedValue = this.getPropertyValueFromStore(nodeReference);
            if (currentValue != null) {
                switch (indexOrder) {
                    case ASCENDING: {
                        Assert.assertTrue((String)("Requested ordering " + indexOrder + " was not respected."), (Values.COMPARATOR.compare(currentValue, storedValue) <= 0 ? 1 : 0) != 0);
                        break;
                    }
                    case DESCENDING: {
                        Assert.assertTrue((String)("Requested ordering " + indexOrder + " was not respected."), (Values.COMPARATOR.compare(currentValue, storedValue) >= 0 ? 1 : 0) != 0);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Can not verify ordering for " + indexOrder);
                    }
                }
            }
            currentValue = storedValue;
        }
    }

    private void assertFoundNodesAndValue(NodeValueIndexCursor node, int nodes, PrimitiveLongSet uniqueIds, IndexValueCapability expectValue) {
        uniqueIds.clear();
        for (int i = 0; i < nodes; ++i) {
            Assert.assertTrue((String)("at least " + nodes + " nodes, was " + uniqueIds.size()), (boolean)node.next());
            long nodeReference = node.nodeReference();
            Assert.assertTrue((String)"all nodes are unique", (boolean)uniqueIds.add(nodeReference));
            if (IndexValueCapability.YES.equals((Object)expectValue)) {
                Assert.assertTrue((String)"has value", (boolean)node.hasValue());
            }
            if (!node.hasValue()) continue;
            Value storedValue = this.getPropertyValueFromStore(nodeReference);
            Assert.assertThat((String)"has correct value", (Object)node.propertyValue(0), (Matcher)CoreMatchers.is((Object)storedValue));
        }
        Assert.assertFalse((String)("no more than " + nodes + " nodes"), (boolean)node.next());
    }

    private void assertFoundNodesAndNoValue(NodeValueIndexCursor node, int nodes, PrimitiveLongSet uniqueIds) {
        uniqueIds.clear();
        for (int i = 0; i < nodes; ++i) {
            Assert.assertTrue((String)("at least " + nodes + " nodes, was " + uniqueIds.size()), (boolean)node.next());
            long nodeReference = node.nodeReference();
            Assert.assertTrue((String)"all nodes are unique", (boolean)uniqueIds.add(nodeReference));
            Assert.assertFalse((boolean)node.hasValue());
        }
        Assert.assertFalse((String)("no more than " + nodes + " nodes"), (boolean)node.next());
    }

    private void assertFoundNodesAndValue(NodeValueIndexCursor node, PrimitiveLongSet uniqueIds, IndexValueCapability expectValue, long ... expected) {
        this.assertFoundNodesAndValue(node, expected.length, uniqueIds, expectValue);
        for (long expectedNode : expected) {
            Assert.assertTrue((String)("expected node " + expectedNode), (boolean)uniqueIds.contains(expectedNode));
        }
    }

    private void assertFoundNodesAndNoValue(NodeValueIndexCursor node, PrimitiveLongSet uniqueIds, long ... expected) {
        this.assertFoundNodesAndNoValue(node, expected.length, uniqueIds);
        for (long expectedNode : expected) {
            Assert.assertTrue((String)("expected node " + expectedNode), (boolean)uniqueIds.contains(expectedNode));
        }
    }

    /*
     * Exception decompiling
     */
    private Value getPropertyValueFromStore(long nodeReference) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void shouldGetNoIndexForMissingTokens() {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        int badLabel = this.token.nodeLabel("BAD_LABEL");
        int badProp = this.token.propertyKey("badProp");
        Assert.assertEquals((String)"bad label", (Object)CapableIndexReference.NO_INDEX, (Object)this.schemaRead.index(badLabel, new int[]{prop}));
        Assert.assertEquals((String)"bad prop", (Object)CapableIndexReference.NO_INDEX, (Object)this.schemaRead.index(label, new int[]{badProp}));
        Assert.assertEquals((String)"just bad", (Object)CapableIndexReference.NO_INDEX, (Object)this.schemaRead.index(badLabel, new int[]{badProp}));
    }

    @Test
    public void shouldGetNoIndexForUnknownTokens() {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        int badLabel = Integer.MAX_VALUE;
        int badProp = Integer.MAX_VALUE;
        Assert.assertEquals((String)"bad label", (Object)CapableIndexReference.NO_INDEX, (Object)this.schemaRead.index(badLabel, new int[]{prop}));
        Assert.assertEquals((String)"bad prop", (Object)CapableIndexReference.NO_INDEX, (Object)this.schemaRead.index(label, new int[]{badProp}));
        Assert.assertEquals((String)"just bad", (Object)CapableIndexReference.NO_INDEX, (Object)this.schemaRead.index(badLabel, new int[]{badProp}));
    }

    @Test
    public void shouldGetVersionAndKeyFromIndexReference() {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        Assert.assertEquals((Object)this.providerKey(), (Object)index.providerKey());
        Assert.assertEquals((Object)this.providerVersion(), (Object)index.providerVersion());
    }

    @Test
    public void shouldNotFindDeletedNodeInIndexScan() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        IndexValueCapability wildcardCapability = index.valueCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();
             PrimitiveLongSet uniqueIds = Primitive.longSet();){
            tx.dataRead().nodeIndexScan((IndexReference)index, node, IndexOrder.NONE);
            Assert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, 35, uniqueIds, wildcardCapability);
            tx.dataWrite().nodeDelete(strOne);
            tx.dataRead().nodeIndexScan((IndexReference)index, node, IndexOrder.NONE);
            this.assertFoundNodesAndValue(node, 34, uniqueIds, wildcardCapability);
        }
    }

    @Test
    public void shouldNotFindDeletedNodeInIndexSeek() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(strOne);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindDNodeWithRemovedLabelInIndexSeek() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindUpdatedNodeInIndexSeek() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldFindUpdatedNodeInIndexSeek() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"ett")});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOne, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldFindSwappedNodeInIndexSeek() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldNotFindDeletedNodeInRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(strOne);
            tx.dataWrite().nodeDelete(strThree1);
            tx.dataWrite().nodeDelete(strThree2);
            tx.dataWrite().nodeDelete(strThree3);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindNodeWithRemovedLabelInRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeRemoveLabel(strThree1, label);
            tx.dataWrite().nodeRemoveLabel(strThree2, label);
            tx.dataWrite().nodeRemoveLabel(strThree3, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindUpdatedNodeInRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataWrite().nodeSetProperty(strThree1, prop, (Value)Values.stringValue((String)"tre"));
            tx.dataWrite().nodeSetProperty(strThree2, prop, (Value)Values.stringValue((String)"tre"));
            tx.dataWrite().nodeSetProperty(strThree3, prop, (Value)Values.stringValue((String)"tre"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldFindUpdatedNodeInRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"ett", (boolean)true, (String)"tre", (boolean)true)});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOne, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldFindSwappedNodeInRangeSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"ones", (boolean)true)});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindDeletedNodeInPrefixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(strOne);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (String)"on")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindNodeWithRemovedLabelInPrefixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (String)"on")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindUpdatedNodeInPrefixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (String)"on")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldFindUpdatedNodeInPrefixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (String)"et")});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOne, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldFindSwappedNodeInPrefixSearch() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (String)"on")});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldNotFindDeletedNodeInCompositeIndex() throws Exception {
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{firstName, surname});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(jackDalton);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jack"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindNodeWithRemovedLabelInCompositeIndex() throws Exception {
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{firstName, surname});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(joeDalton, label);
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Joe"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldNotFindUpdatedNodeInCompositeIndex() throws Exception {
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{firstName, surname});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(jackDalton, firstName, (Value)Values.stringValue((String)"Jesse"));
            tx.dataWrite().nodeSetProperty(jackDalton, surname, (Value)Values.stringValue((String)"James"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jack"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assert.assertFalse((boolean)node.next());
        }
    }

    @Test
    public void shouldFindUpdatedNodeInCompositeIndex() throws Exception {
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{firstName, surname});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(jackDalton, firstName, (Value)Values.stringValue((String)"Jesse"));
            tx.dataWrite().nodeSetProperty(jackDalton, surname, (Value)Values.stringValue((String)"James"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jesse"), IndexQuery.exact((int)surname, (Object)"James")});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)jackDalton, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldFindSwappedNodeInCompositeIndex() throws Exception {
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{firstName, surname});
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(joeDalton, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataWrite().nodeSetProperty(strOneNoLabel, firstName, (Value)Values.stringValue((String)"Jesse"));
            tx.dataWrite().nodeSetProperty(strOneNoLabel, surname, (Value)Values.stringValue((String)"James"));
            tx.dataRead().nodeIndexSeek((IndexReference)index, node, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jesse"), IndexQuery.exact((int)surname, (Object)"James")});
            Assert.assertTrue((boolean)node.next());
            Assert.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
        }
    }

    @Test
    public void shouldCountDistinctValues() throws Exception {
        Assume.assumeTrue((boolean)this.distinctValuesSupport());
        int label = this.token.nodeLabel("Node");
        int key = this.token.propertyKey("prop2");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{key});
        int expectedCount = 100;
        HashMap<Value, Set> expected = new HashMap<Value, Set>();
        try (Transaction tx = this.session.beginTransaction();){
            Write write = tx.dataWrite();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < expectedCount; ++i) {
                Object value = random.nextBoolean() ? String.valueOf(i % 10) : Integer.valueOf(i % 10);
                long nodeId = write.nodeCreate();
                write.nodeAddLabel(nodeId, label);
                write.nodeSetProperty(nodeId, key, Values.of((Object)value));
                expected.computeIfAbsent(Values.of((Object)value), v -> new HashSet()).add(nodeId);
            }
            tx.success();
        }
        tx = this.session.beginTransaction();
        var7_7 = null;
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexDistinctValues((IndexReference)index, node);
            long totalCount = 0L;
            boolean hasValues = true;
            while (node.next()) {
                long count = node.nodeReference();
                if (node.hasValue() && node.propertyValue(0) != null) {
                    Value value = node.propertyValue(0);
                    Set expectedNodes = (Set)expected.remove(value);
                    Assert.assertNotNull((Object)expectedNodes);
                    Assert.assertEquals((long)count, (long)expectedNodes.size());
                } else {
                    hasValues = false;
                }
                totalCount += count;
            }
            if (hasValues) {
                Assert.assertTrue((String)((Object)expected).toString(), (boolean)expected.isEmpty());
            }
            Assert.assertEquals((long)expectedCount, (long)totalCount);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldCountDistinctButSimilarPointValues() throws Exception {
        Assume.assumeTrue((boolean)this.distinctValuesSupport());
        int label = this.token.nodeLabel("Node");
        int key = this.token.propertyKey("prop3");
        CapableIndexReference index = this.schemaRead.index(label, new int[]{key});
        HashMap<PointValue, Integer> expected = new HashMap<PointValue, Integer>();
        expected.put(POINT_1, 1);
        expected.put(POINT_2, 2);
        try (Transaction tx = this.session.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexDistinctValues((IndexReference)index, node);
            while (node.next()) {
                Assert.assertTrue((boolean)node.hasValue());
                Assert.assertTrue((boolean)expected.containsKey(node.propertyValue(0)));
                Assert.assertEquals((long)((Integer)expected.remove(node.propertyValue(0))).intValue(), (long)Math.toIntExact(node.nodeReference()));
            }
            Assert.assertTrue((boolean)expected.isEmpty());
        }
    }

    private long nodeWithProp(GraphDatabaseService graphDb, Object value) {
        return this.nodeWithProp(graphDb, "prop", value);
    }

    private long nodeWithProp(GraphDatabaseService graphDb, String key, Object value) {
        Node node = graphDb.createNode(new Label[]{Label.label((String)"Node")});
        node.setProperty(key, value);
        return node.getId();
    }

    private long nodeWithNoLabel(GraphDatabaseService graphDb, Object value) {
        Node node = graphDb.createNode();
        node.setProperty("prop", value);
        return node.getId();
    }

    private long person(GraphDatabaseService graphDb, String firstName, String surname) {
        Node node = graphDb.createNode(new Label[]{Label.label((String)"Person")});
        node.setProperty("firstname", (Object)firstName);
        node.setProperty("surname", (Object)surname);
        return node.getId();
    }

    static {
        POINT_1 = PointValue.parse((CharSequence)"{latitude: 40.7128, longitude: -74.0060, crs: 'wgs-84'}");
        POINT_2 = PointValue.parse((CharSequence)"{latitude: 40.7128, longitude: -74.006000001, crs: 'wgs-84'}");
    }
}

