/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Transaction;

public abstract class ExplicitIndexCursorWritesTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final String INDEX_NAME = "foo";
    private static final String KEY = "bar";
    private static final String VALUE = "this is it";

    @Test
    public void shouldCreateExplicitNodeIndexEagerly() throws Exception {
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("type", "exact");
            config.put("provider", "lucene");
            indexWrite.nodeExplicitIndexCreate(INDEX_NAME, config);
            tx.success();
        }
        var2_2 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Assert.assertTrue((boolean)graphDb.index().existsForNodes(INDEX_NAME));
            ctx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldCreateExplicitNodeIndexLazily() throws Exception {
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("type", "exact");
            config.put("provider", "lucene");
            indexWrite.nodeExplicitIndexCreateLazily(INDEX_NAME, config);
            tx.success();
        }
        var2_2 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Assert.assertTrue((boolean)graphDb.index().existsForNodes(INDEX_NAME));
            ctx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldAddNodeToExplicitIndex() throws Exception {
        long nodeId;
        try (Transaction tx = this.session.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            indexWrite.nodeAddToExplicitIndex(INDEX_NAME, nodeId, KEY, (Object)VALUE);
            tx.success();
        }
        var4_2 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forNodes(INDEX_NAME).get(KEY, (Object)VALUE);
            MatcherAssert.assertThat((Object)((Node)hits.next()).getId(), (Matcher)CoreMatchers.equalTo((Object)nodeId));
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRemoveNodeFromExplicitIndex() throws Exception {
        long nodeId = this.addNodeToExplicitIndex();
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            indexWrite.nodeRemoveFromExplicitIndex(INDEX_NAME, nodeId);
            tx.success();
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forNodes(INDEX_NAME).get(KEY, (Object)VALUE);
            Assert.assertFalse((boolean)hits.hasNext());
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldHandleRemoveNodeFromExplicitIndexTwice() throws Exception {
        ExplicitIndexWrite indexWrite;
        long nodeId = this.addNodeToExplicitIndex();
        try (Transaction tx = this.session.beginTransaction();){
            indexWrite = tx.indexWrite();
            indexWrite.nodeRemoveFromExplicitIndex(INDEX_NAME, nodeId);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var4_3 = null;
        try {
            indexWrite = tx.indexWrite();
            indexWrite.nodeRemoveFromExplicitIndex(INDEX_NAME, nodeId);
            tx.success();
        }
        catch (Throwable indexWrite2) {
            var4_3 = indexWrite2;
            throw indexWrite2;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable indexWrite2) {
                        var4_3.addSuppressed(indexWrite2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forNodes(INDEX_NAME).get(KEY, (Object)VALUE);
            Assert.assertFalse((boolean)hits.hasNext());
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRemoveNonExistingNodeFromExplicitIndex() throws Exception {
        long nodeId = this.addNodeToExplicitIndex();
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            indexWrite.nodeRemoveFromExplicitIndex(INDEX_NAME, nodeId + 1L);
            tx.success();
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forNodes(INDEX_NAME).get(KEY, (Object)VALUE);
            MatcherAssert.assertThat((Object)((Node)hits.next()).getId(), (Matcher)CoreMatchers.equalTo((Object)nodeId));
            Assert.assertFalse((boolean)hits.hasNext());
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldCreateExplicitRelationshipIndexEagerly() throws Exception {
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("type", "exact");
            config.put("provider", "lucene");
            indexWrite.relationshipExplicitIndexCreate(INDEX_NAME, config);
            tx.success();
        }
        var2_2 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Assert.assertTrue((boolean)graphDb.index().existsForRelationships(INDEX_NAME));
            ctx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldCreateExplicitRelationshipIndexLazily() throws Exception {
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("type", "exact");
            config.put("provider", "lucene");
            indexWrite.relationshipExplicitIndexCreateLazily(INDEX_NAME, config);
            tx.success();
        }
        var2_2 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Assert.assertTrue((boolean)graphDb.index().existsForRelationships(INDEX_NAME));
            ctx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldCreateExplicitIndexTwice() throws Exception {
        ExplicitIndexWrite indexWrite;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("type", "exact");
        config.put("provider", "lucene");
        try (Transaction tx = this.session.beginTransaction();){
            indexWrite = tx.indexWrite();
            indexWrite.nodeExplicitIndexCreateLazily(INDEX_NAME, config);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var3_3 = null;
        try {
            indexWrite = tx.indexWrite();
            indexWrite.nodeExplicitIndexCreateLazily(INDEX_NAME, config);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var3_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Assert.assertTrue((boolean)graphDb.index().existsForNodes(INDEX_NAME));
            ctx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldAddRelationshipToExplicitIndex() throws Exception {
        long relId;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            relId = graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"R")).getId();
            ctx.success();
        }
        var4_2 = null;
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            indexWrite.relationshipAddToExplicitIndex(INDEX_NAME, relId, KEY, (Object)VALUE);
            tx.success();
        }
        catch (Throwable indexWrite) {
            var4_2 = indexWrite;
            throw indexWrite;
        }
        ctx = graphDb.beginTx();
        var4_2 = null;
        try {
            IndexHits hits = graphDb.index().forRelationships(INDEX_NAME).get(KEY, (Object)VALUE);
            MatcherAssert.assertThat((Object)((Relationship)hits.next()).getId(), (Matcher)CoreMatchers.equalTo((Object)relId));
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var4_2 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    @Test
    public void shouldRemoveRelationshipFromExplicitIndex() throws Exception {
        long relId = this.addRelationshipToExplicitIndex();
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            indexWrite.relationshipRemoveFromExplicitIndex(INDEX_NAME, relId);
            tx.success();
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forNodes(INDEX_NAME).get(KEY, (Object)VALUE);
            Assert.assertFalse((boolean)hits.hasNext());
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldHandleRemoveRelationshipFromExplicitIndexTwice() throws Exception {
        ExplicitIndexWrite indexWrite;
        long relId = this.addRelationshipToExplicitIndex();
        try (Transaction tx = this.session.beginTransaction();){
            indexWrite = tx.indexWrite();
            indexWrite.relationshipRemoveFromExplicitIndex(INDEX_NAME, relId);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var4_3 = null;
        try {
            indexWrite = tx.indexWrite();
            indexWrite.relationshipRemoveFromExplicitIndex(INDEX_NAME, relId);
            tx.success();
        }
        catch (Throwable indexWrite2) {
            var4_3 = indexWrite2;
            throw indexWrite2;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable indexWrite2) {
                        var4_3.addSuppressed(indexWrite2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forRelationships(INDEX_NAME).get(KEY, (Object)VALUE);
            Assert.assertFalse((boolean)hits.hasNext());
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRemoveNonExistingRelationshipFromExplicitIndex() throws Exception {
        long relId = this.addRelationshipToExplicitIndex();
        try (Transaction tx = this.session.beginTransaction();){
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            indexWrite.relationshipRemoveFromExplicitIndex(INDEX_NAME, relId + 1L);
            tx.success();
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            IndexHits hits = graphDb.index().forRelationships(INDEX_NAME).get(KEY, (Object)VALUE);
            MatcherAssert.assertThat((Object)((Relationship)hits.next()).getId(), (Matcher)CoreMatchers.equalTo((Object)relId));
            Assert.assertFalse((boolean)hits.hasNext());
            hits.close();
            ctx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    private long addNodeToExplicitIndex() throws Exception {
        long nodeId;
        try (Transaction tx = this.session.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            ExplicitIndexWrite indexWrite = tx.indexWrite();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("type", "exact");
            config.put("provider", "lucene");
            indexWrite.nodeExplicitIndexCreateLazily(INDEX_NAME, config);
            indexWrite.nodeAddToExplicitIndex(INDEX_NAME, nodeId, KEY, (Object)VALUE);
            tx.success();
        }
        return nodeId;
    }

    private long addRelationshipToExplicitIndex() {
        long relId;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Relationship rel = graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"R"));
            relId = rel.getId();
            graphDb.index().forRelationships(INDEX_NAME).add((PropertyContainer)rel, KEY, (Object)VALUE);
            ctx.success();
        }
        return relId;
    }
}

