/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexReadAsserts;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;

public abstract class ExplicitIndexCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    @Override
    void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            graphDb.index().forNodes("foo").add((PropertyContainer)graphDb.createNode(), "bar", (Object)"this is it");
            Relationship edge = graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"LALA"));
            graphDb.index().forRelationships("rels").add((PropertyContainer)edge, "alpha", (Object)"betting on the wrong string");
            tx.success();
        }
    }

    @Test
    public void shouldFindNodeByLookup() throws Exception {
        try (NodeExplicitIndexCursor cursor = this.cursors.allocateNodeExplicitIndexCursor();
             PrimitiveLongSet nodes = Primitive.longSet();){
            this.indexRead.nodeExplicitIndexLookup(cursor, "foo", "bar", (Object)"this is it");
            IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, nodes);
            this.indexRead.nodeExplicitIndexLookup(cursor, "foo", "bar", (Object)"not that");
            IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 0, nodes);
        }
    }

    @Test
    public void shouldFindNodeByQuery() throws Exception {
        try (NodeExplicitIndexCursor cursor = this.cursors.allocateNodeExplicitIndexCursor();
             PrimitiveLongSet nodes = Primitive.longSet();){
            this.indexRead.nodeExplicitIndexQuery(cursor, "foo", (Object)"bar:this*");
            IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, nodes);
            nodes.clear();
            this.indexRead.nodeExplicitIndexQuery(cursor, "foo", "bar", (Object)"this*");
            IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, nodes);
            this.indexRead.nodeExplicitIndexQuery(cursor, "foo", (Object)"bar:that*");
            IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 0, nodes);
            this.indexRead.nodeExplicitIndexQuery(cursor, "foo", "bar", (Object)"that*");
            IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 0, nodes);
        }
    }

    @Test
    public void shouldFindRelationshipByLookup() throws Exception {
        try (RelationshipExplicitIndexCursor cursor = this.cursors.allocateRelationshipExplicitIndexCursor();
             PrimitiveLongSet edges = Primitive.longSet();){
            this.indexRead.relationshipExplicitIndexLookup(cursor, "rels", "alpha", (Object)"betting on the wrong string", -1L, -1L);
            IndexReadAsserts.assertFoundRelationships((RelationshipIndexCursor)cursor, 1, edges);
            this.indexRead.relationshipExplicitIndexLookup(cursor, "rels", "bar", (Object)"not that", -1L, -1L);
            IndexReadAsserts.assertFoundRelationships((RelationshipIndexCursor)cursor, 0, edges);
        }
    }

    @Test
    public void shouldFindRelationshipByQuery() throws Exception {
        try (RelationshipExplicitIndexCursor cursor = this.cursors.allocateRelationshipExplicitIndexCursor();
             PrimitiveLongSet relationships = Primitive.longSet();){
            this.indexRead.relationshipExplicitIndexQuery(cursor, "rels", (Object)"alpha:betting*", -1L, -1L);
            IndexReadAsserts.assertFoundRelationships((RelationshipIndexCursor)cursor, 1, relationships);
            relationships.clear();
            this.indexRead.relationshipExplicitIndexQuery(cursor, "rels", "alpha", (Object)"betting*", -1L, -1L);
            IndexReadAsserts.assertFoundRelationships((RelationshipIndexCursor)cursor, 1, relationships);
            this.indexRead.relationshipExplicitIndexQuery(cursor, "rels", (Object)"alpha:that*", -1L, -1L);
            IndexReadAsserts.assertFoundRelationships((RelationshipIndexCursor)cursor, 0, relationships);
            this.indexRead.relationshipExplicitIndexQuery(cursor, "rels", "alpha", (Object)"that*", -1L, -1L);
            IndexReadAsserts.assertFoundRelationships((RelationshipIndexCursor)cursor, 0, relationships);
        }
    }
}

