/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

public abstract class DeepRelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long three_root;
    private static int expected_total;
    private static int expected_unique;
    private RelationshipType PARENT = RelationshipType.withName((String)"PARENT");

    @Override
    void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            Node inter;
            int i;
            Node root = graphDb.createNode();
            three_root = root.getId();
            Node[] leafs = new Node[32];
            for (int i2 = 0; i2 < leafs.length; ++i2) {
                leafs[i2] = graphDb.createNode();
            }
            int offset = 0;
            int duplicate = 12;
            Node interdup = graphDb.createNode();
            interdup.createRelationshipTo(root, this.PARENT);
            offset = this.relate(duplicate, leafs, offset, interdup);
            for (i = 0; i < 5; ++i) {
                inter = graphDb.createNode();
                inter.createRelationshipTo(root, this.PARENT);
                offset = this.relate(3 + i, leafs, offset, inter);
            }
            interdup.createRelationshipTo(root, this.PARENT);
            for (i = 0; i < 4; ++i) {
                inter = graphDb.createNode();
                inter.createRelationshipTo(root, this.PARENT);
                offset = this.relate(2 + i, leafs, offset, inter);
            }
            Node inter2 = graphDb.createNode();
            inter2.createRelationshipTo(root, this.PARENT);
            offset = this.relate(1, leafs, offset, inter2);
            expected_total = offset + duplicate;
            expected_unique = leafs.length;
            tx.success();
        }
    }

    private int relate(int count, Node[] selection, int offset, Node parent) {
        for (int i = 0; i < count; ++i) {
            selection[offset++ % selection.length].createRelationshipTo(parent, this.PARENT);
        }
        return offset;
    }

    @Test
    public void shouldTraverseTreeOfDepthThree() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship1 = this.cursors.allocateRelationshipTraversalCursor();
             RelationshipTraversalCursor relationship2 = this.cursors.allocateRelationshipTraversalCursor();
             PrimitiveLongSet leafs = Primitive.longSet();){
            long total = 0L;
            this.read.singleNode(three_root, node);
            Assert.assertTrue((String)"access root node", (boolean)node.next());
            node.relationships(group);
            Assert.assertFalse((String)"single root", (boolean)node.next());
            Assert.assertTrue((String)"access group of root", (boolean)group.next());
            group.incoming(relationship1);
            Assert.assertFalse((String)"single group of root", (boolean)group.next());
            while (relationship1.next()) {
                relationship1.neighbour(node);
                Assert.assertTrue((String)"child level 1", (boolean)node.next());
                node.relationships(group);
                Assert.assertFalse((String)"single node", (boolean)node.next());
                Assert.assertTrue((String)"group of level 1 child", (boolean)group.next());
                group.incoming(relationship2);
                Assert.assertFalse((String)"single group of level 1 child", (boolean)group.next());
                while (relationship2.next()) {
                    leafs.add(relationship2.neighbourNodeReference());
                    ++total;
                }
            }
            Assert.assertEquals((String)"total number of leaf nodes", (long)expected_total, (long)total);
            Assert.assertEquals((String)"number of distinct leaf nodes", (long)expected_unique, (long)leafs.size());
        }
    }
}

