/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.counts.CountsStore;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.InternalErrorTracer;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.StorageFileSelection;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommand;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;

public interface StorageEngine
extends ReadableStorageEngine,
Lifecycle {
    public String name();

    public byte id();

    public CommandCreationContext newCommandCreationContext(boolean var1);

    public TransactionValidatorFactory createTransactionValidatorFactory(Config var1);

    public StorageLocks createStorageLocks(ResourceLocker var1);

    public void addIndexUpdateListener(IndexUpdateListener var1);

    public List<StorageCommand> createCommands(ReadableTransactionState var1, StorageReader var2, CommandCreationContext var3, LockTracer var4, TxStateVisitor.Decorator var5, CursorContext var6, StoreCursors var7, MemoryTracker var8) throws KernelException;

    public EnrichmentCommand createEnrichmentCommand(KernelVersion var1, Enrichment var2);

    public void lockRecoveryCommands(CommandBatch var1, LockService var2, LockGroup var3, TransactionApplicationMode var4) throws IOException;

    public void apply(StorageEngineTransaction var1, TransactionApplicationMode var2) throws Exception;

    public void release(ReadableTransactionState var1, CursorContext var2, CommandCreationContext var3, boolean var4);

    public void checkpoint(DatabaseFlushEvent var1, AsyncBlockAccessor var2, CursorContext var3) throws IOException;

    public void dumpDiagnostics(InternalLog var1, DiagnosticsLogger var2);

    public void shutdown();

    public Collection<Path> listStorageFiles(StorageFileSelection var1);

    public StoreId retrieveStoreId();

    public Lifecycle schemaAndTokensLifecycle(boolean var1);

    public MetadataProvider metadataProvider();

    public LogMetadataProvider logMetadataProvider();

    public CountsStore countsAccessor();

    public StoreEntityCounters storeEntityCounters();

    public InternalErrorTracer internalErrorTracer();

    default public TransactionStateBehaviour transactionStateBehaviour() {
        return TransactionStateBehaviour.DEFAULT_BEHAVIOUR;
    }

    public void preAllocateStoreFilesForCommands(StorageEngineTransaction var1, TransactionApplicationMode var2) throws OutOfDiskSpaceException, IOException;

    public void prefetchPagesForCommands(StorageEngineTransaction var1, TransactionApplicationMode var2);

    default public long estimateAvailableReservedSpace() {
        return 0L;
    }
}

