/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;

public class DeletedNodeStillHasRelationshipsException
extends ConstraintViolationTransactionFailureException {
    private DeletedNodeStillHasRelationshipsException(ErrorGqlStatusObject errorGqlStatusObject, String message) {
        super(errorGqlStatusObject, message);
    }

    public static DeletedNodeStillHasRelationshipsException nodeStillHasRelationships(long nodeId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_G1001).build();
        String message = "Cannot delete node<%s>, because it still has relationships. To delete this node, you must first delete its relationships.".formatted(nodeId);
        return new DeletedNodeStillHasRelationshipsException(gql, message);
    }

    public static DeletedNodeStillHasRelationshipsException nodeCreatedInThisTxStillHasRelationships() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_G1001).build();
        String message = "Cannot delete node that was created in this transaction, because it still has relationships.";
        return new DeletedNodeStillHasRelationshipsException(gql, message);
    }
}

