/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public final class TokenLengthLimitExceededException
extends GqlRuntimeException
implements Status.HasStatus {
    private TokenLengthLimitExceededException(ErrorGqlStatusObject errorGqlStatusObject, String tokenName, String tokenType, int maxLength) {
        super(errorGqlStatusObject, TokenLengthLimitExceededException.getMessage(tokenName, tokenType, maxLength));
    }

    public static TokenLengthLimitExceededException tokenNameTooLong(String tokenName, String tokenType, int maxLength) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I50).withParam(GqlParams.StringParam.input, tokenName).withParam(GqlParams.StringParam.tokenType, tokenType).withParam(GqlParams.NumberParam.value, (Number)maxLength).build();
        return new TokenLengthLimitExceededException(gql, tokenName, tokenType, maxLength);
    }

    private static String getMessage(String tokenName, String tokenType, int maxLength) {
        return String.format("Invalid input %s... A %s name cannot be longer than %d.", tokenName.substring(0, Math.min(tokenName.length(), 100)), tokenType, maxLength);
    }

    public Status status() {
        return Status.Schema.TokenLengthError;
    }
}

