/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions;

import java.util.Objects;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.kernel.api.exceptions.Status;

public class EntityNotFoundException
extends KernelException {
    private final EntityType entityType;
    private final String entityId;

    private EntityNotFoundException(ErrorGqlStatusObject gqlStatusObject, String message, EntityType entityType, String entityId) {
        super(gqlStatusObject, (Status)Status.Statement.EntityNotFound, message, new Object[0]);
        this.entityType = Objects.requireNonNull(entityType);
        this.entityId = Objects.requireNonNull(entityId);
    }

    public static EntityNotFoundException internalError(String msgTitle, EntityType entityType, String entityId) {
        String message = String.format("Unable to load %s %s.", entityType.name(), entityId);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new EntityNotFoundException(gql, message, entityType, entityId);
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public String entityId() {
        return this.entityId;
    }
}

