/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions;

import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;

public class TransactionFailureException
extends KernelException {
    @Deprecated
    public TransactionFailureException(Status statusCode, Throwable cause, String message, Object ... parameters) {
        super(statusCode, cause, message, parameters);
    }

    protected TransactionFailureException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, Throwable cause, String message, Object ... parameters) {
        super(gqlStatusObject, statusCode, cause, message, parameters);
    }

    @Deprecated
    public TransactionFailureException(Status statusCode, Throwable cause) {
        super(statusCode, cause);
    }

    private TransactionFailureException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, Throwable cause) {
        super(gqlStatusObject, statusCode, cause);
    }

    @Deprecated
    public TransactionFailureException(Status statusCode, String message, Object ... parameters) {
        super(statusCode, message, parameters);
    }

    protected TransactionFailureException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Object ... parameters) {
        super(gqlStatusObject, statusCode, message, parameters);
    }

    @Deprecated
    public TransactionFailureException(String message, Throwable cause) {
        super((Status)Status.Transaction.TransactionStartFailed, cause, message, new Object[0]);
    }

    private TransactionFailureException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, (Status)Status.Transaction.TransactionStartFailed, cause, message, new Object[0]);
    }

    public static TransactionFailureException internalError(String msgTitle, String message, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new TransactionFailureException(gql, message, cause);
    }

    public static TransactionFailureException internalError(Status statusCode, String msgTitle, String message, Object ... parameters) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new TransactionFailureException(gql, statusCode, message, parameters);
    }

    public static TransactionFailureException internalError(Status statusCode, Throwable cause, String msgTitle, String message, Object ... parameters) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new TransactionFailureException(gql, statusCode, cause, message, parameters);
    }

    public static TransactionFailureException leaseExpired(int currentLeaseId, int leaseId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N08).build();
        return new TransactionFailureException(gql, (Status)Status.Transaction.LeaseExpired, "The lease used for the transaction has expired: [current lease id:%d, transaction lease id:%d]", currentLeaseId, leaseId);
    }

    public static TransactionFailureException invalidatedLease() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N08).build();
        return new TransactionFailureException(gql, (Status)Status.Transaction.LeaseExpired, "The lease has been invalidated", new Object[0]);
    }

    public static TransactionFailureException unexpectedOutcome(String outcome) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N09).build();
        return new TransactionFailureException(gql, (Status)Status.General.UnknownError, "Unexpected outcome: " + outcome, new Object[0]);
    }

    public static TransactionFailureException replicationError(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N33).build();
        return new TransactionFailureException(gql, (Status)Status.Cluster.ReplicationFailure, cause);
    }

    public static TransactionFailureException innerTransactionsStillOpen() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN07).build();
        return new TransactionFailureException(gql, (Status)Status.Transaction.TransactionCommitFailed, "The transaction cannot be committed when it has open inner transactions.", new Object[0]);
    }

    public static TransactionFailureException unknownError(Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return new TransactionFailureException(gql, (Status)Status.General.UnknownError, e);
    }

    public static TransactionFailureException cannotBeCommitedInReadOnlyDb() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N08).build();
        return new TransactionFailureException(gql, (Status)Status.General.ForbiddenOnReadOnlyDatabase, "Transactions cannot be committed in a read-only Neo4j database", new Object[0]);
    }

    public static TransactionFailureException cannotRollbackCannotDropCreatedConstraintIndex(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N01).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N10).build()).build();
        return new TransactionFailureException(gql, (Status)Status.Transaction.TransactionRollbackFailed, cause, "Could not drop created constraint indexes", new Object[0]);
    }

    public static TransactionFailureException couldNotApplyTransaction(String batchString, Throwable cause, Log log) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN05).build();
        String message = "Could not apply the transaction: %s to the store after written to log.".formatted(batchString);
        TransactionFailureException e = new TransactionFailureException(gql, (Status)Status.Transaction.TransactionCommitFailed, cause, message, new Object[0]);
        log.error(message, (Throwable)((Object)e));
        return e;
    }

    public static TransactionFailureException couldNotAppendTransaction(String batchString, Throwable cause, Log log) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_2DN06).build();
        String message = "Could not append transaction: %s to log.".formatted(batchString);
        TransactionFailureException e = new TransactionFailureException(gql, (Status)Status.Transaction.TransactionLogError, cause, message, new Object[0]);
        log.error(message, (Throwable)((Object)e));
        return e;
    }

    public static TransactionFailureException couldNotPreallocateDiskSpace(String batchString, Status status, Throwable cause, Log log) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N59).build();
        String message = "Could not preallocate disk space for the transaction: %s".formatted(batchString);
        TransactionFailureException e = new TransactionFailureException(gql, status, cause, message, new Object[0]);
        log.error(message, (Throwable)((Object)e));
        return e;
    }
}

