/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.storageengine.api.CommandVersion;

public enum TransactionApplicationMode {
    INTERNAL(false, true, false, CommandVersion.AFTER),
    EXTERNAL(true, true, false, CommandVersion.AFTER),
    RECOVERY(true, true, false, CommandVersion.AFTER),
    REVERSE_RECOVERY(false, false, false, CommandVersion.BEFORE),
    MVCC_ROLLBACK(false, true, true, CommandVersion.BEFORE),
    MVCC_INCOMPLETE_REVERSE_RECOVERY(false, true, true, CommandVersion.BEFORE);

    private final boolean needsHighIdTracking;
    private final boolean indexesAndCounts;
    private final boolean rollbackIdProcessing;
    private final CommandVersion version;

    private TransactionApplicationMode(boolean needsHighIdTracking, boolean indexesAndCounts, boolean rollbackIdProcessing, CommandVersion version) {
        this.needsHighIdTracking = needsHighIdTracking;
        this.indexesAndCounts = indexesAndCounts;
        this.rollbackIdProcessing = rollbackIdProcessing;
        this.version = version;
    }

    public boolean needsHighIdTracking() {
        return this.needsHighIdTracking;
    }

    public boolean needsAuxiliaryStores() {
        return this.indexesAndCounts;
    }

    public CommandVersion version() {
        return this.version;
    }

    public boolean rollbackIdProcessing() {
        return this.rollbackIdProcessing;
    }

    public boolean isReverseStep() {
        return CommandVersion.BEFORE == this.version;
    }
}

