/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import java.util.function.IntPredicate;

public abstract class PropertySelection {
    public static final int UNKNOWN_NUMBER_OF_KEYS = -1;
    private final boolean keysOnly;
    public static final PropertySelection ALL_PROPERTIES = PropertySelection.allProperties(false);
    public static final PropertySelection ALL_PROPERTY_KEYS = PropertySelection.allProperties(true);
    public static final PropertySelection NO_PROPERTIES = new PropertySelection(true){

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return 0;
        }

        @Override
        public int key(int index) {
            throw new IllegalStateException("This selection has no keys");
        }

        @Override
        public boolean test(int key) {
            return false;
        }

        @Override
        public int lowestKey() {
            return -1;
        }

        @Override
        public int highestKey() {
            return -1;
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            return this;
        }
    };

    protected PropertySelection(boolean keysOnly) {
        this.keysOnly = keysOnly;
    }

    public abstract boolean isLimited();

    public abstract int numberOfKeys();

    public boolean isEmpty() {
        return this.numberOfKeys() == 0;
    }

    public abstract int key(int var1);

    public abstract boolean test(int var1);

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    public abstract int lowestKey();

    public abstract int highestKey();

    public abstract PropertySelection excluding(IntPredicate var1);

    public String toString() {
        return String.format("Property%sSelection", this.keysOnly ? "Key" : "");
    }

    public static PropertySelection selection(int key) {
        return SingleKey.singleKey(false, key);
    }

    public static PropertySelection selection(int ... keys) {
        return PropertySelection.selection(false, keys);
    }

    public static PropertySelection onlyKeysSelection(int ... keys) {
        return PropertySelection.selection(true, keys);
    }

    private static PropertySelection selection(boolean keysOnly, int[] keys) {
        if (keys == null) {
            return keysOnly ? ALL_PROPERTY_KEYS : ALL_PROPERTIES;
        }
        if (keys.length == 0) {
            return NO_PROPERTIES;
        }
        if (keys.length == 1) {
            int key = keys[0];
            return key == -1 ? NO_PROPERTIES : SingleKey.singleKey(keysOnly, key);
        }
        return new MultipleKeys(keysOnly, keys);
    }

    private static PropertySelection allProperties(boolean keysOnly) {
        return new PropertySelection(keysOnly){

            @Override
            public boolean isLimited() {
                return false;
            }

            @Override
            public int numberOfKeys() {
                return -1;
            }

            @Override
            public int key(int index) {
                return -1;
            }

            @Override
            public boolean test(int key) {
                return true;
            }

            @Override
            public int lowestKey() {
                return 0;
            }

            @Override
            public int highestKey() {
                return Integer.MAX_VALUE;
            }

            @Override
            public PropertySelection excluding(IntPredicate filter) {
                return new AllExcept(this.isKeysOnly(), filter);
            }

            @Override
            public String toString() {
                return super.toString() + "[*]";
            }
        };
    }

    private static class SingleKey
    extends PropertySelection {
        private static final int LOW_ID_THRESHOLD = 128;
        private static final PropertySelection[] SINGLE_LOW_ID_SELECTIONS = new PropertySelection[128];
        private static final PropertySelection[] SINGLE_LOW_ID_KEY_SELECTIONS = new PropertySelection[128];
        private final int key;

        private static PropertySelection singleKey(boolean keysOnly, int key) {
            if (key < 128 && key >= 0) {
                return keysOnly ? SINGLE_LOW_ID_KEY_SELECTIONS[key] : SINGLE_LOW_ID_SELECTIONS[key];
            }
            return new SingleKey(keysOnly, key);
        }

        private SingleKey(boolean keysOnly, int key) {
            super(keysOnly);
            this.key = key;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return 1;
        }

        @Override
        public int key(int index) {
            assert (index == 0);
            return this.key;
        }

        @Override
        public boolean test(int key) {
            return this.key == key;
        }

        @Override
        public int lowestKey() {
            return this.key;
        }

        @Override
        public int highestKey() {
            return this.key;
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            return filter.test(this.key) ? NO_PROPERTIES : this;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.key + "]";
        }

        static {
            for (int key = 0; key < SINGLE_LOW_ID_SELECTIONS.length; ++key) {
                SingleKey.SINGLE_LOW_ID_SELECTIONS[key] = new SingleKey(false, key);
                SingleKey.SINGLE_LOW_ID_KEY_SELECTIONS[key] = new SingleKey(true, key);
            }
        }
    }

    private static class MultipleKeys
    extends PropertySelection {
        private final int[] keys;

        private MultipleKeys(boolean keysOnly, int[] keys) {
            super(keysOnly);
            this.keys = this.cloneAndCleanUp(keys);
        }

        private int[] cloneAndCleanUp(int[] suppliedKeys) {
            int[] keys = (int[])suppliedKeys.clone();
            Arrays.sort(keys);
            if (keys[0] == -1) {
                int start;
                for (start = 1; start < keys.length && keys[start] == -1; ++start) {
                }
                keys = Arrays.copyOfRange(keys, start, keys.length);
            }
            return keys;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return this.keys.length;
        }

        @Override
        public int key(int index) {
            assert (index >= 0 && index < this.keys.length);
            return this.keys[index];
        }

        @Override
        public boolean test(int key) {
            for (int k : this.keys) {
                if (k != key) continue;
                return true;
            }
            return false;
        }

        @Override
        public int lowestKey() {
            return this.keys[0];
        }

        @Override
        public int highestKey() {
            return this.keys[this.keys.length - 1];
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            int[] newKeys = new int[this.keys.length];
            int t = 0;
            for (int key : this.keys) {
                if (filter.test(key)) continue;
                newKeys[t++] = key;
            }
            if (t == this.keys.length) {
                return this;
            }
            return PropertySelection.selection(this.isKeysOnly(), Arrays.copyOf(newKeys, t));
        }

        @Override
        public String toString() {
            return super.toString() + "[" + Arrays.toString(this.keys) + "]";
        }
    }

    private static class AllExcept
    extends PropertySelection {
        private final IntPredicate excluded;

        AllExcept(boolean keysOnly, IntPredicate excluded) {
            super(keysOnly);
            this.excluded = excluded;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return -1;
        }

        @Override
        public int key(int index) {
            throw new IllegalStateException("This selection has no discrete number of keys");
        }

        @Override
        public boolean test(int key) {
            return !this.excluded.test(key);
        }

        @Override
        public int lowestKey() {
            return 0;
        }

        @Override
        public int highestKey() {
            return Integer.MAX_VALUE;
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            return new AllExcept(this.isKeysOnly(), this.excluded.or(filter));
        }
    }
}

