/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Clock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.util.Preconditions;

@Deprecated
class ThrottlingBeanSnapshotProxy
implements InvocationHandler {
    private final Set<Method> getters;
    private final Object target;
    private final Clock clock;
    private final Object lock = new Object();
    private final long updateInterval;
    private long lastUpdateTime;
    private Map<Method, ?> lastSnapshot;

    private <T> ThrottlingBeanSnapshotProxy(Class<T> iface, T target, long updateInterval, Clock clock) {
        this.getters = Arrays.stream(iface.getDeclaredMethods()).filter(m -> m.getReturnType() != Void.TYPE).filter(m -> m.getParameterCount() == 0).collect(Collectors.toSet());
        this.target = target;
        this.updateInterval = updateInterval;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (!this.getters.contains(method)) {
            return method.invoke(this.target, args);
        }
        Object object = this.lock;
        synchronized (object) {
            long now = this.clock.millis();
            long age = now - this.lastUpdateTime;
            if (this.lastSnapshot == null || age >= this.updateInterval) {
                this.lastUpdateTime = now;
                this.lastSnapshot = this.takeSnapshot();
            }
            return this.lastSnapshot.get(method);
        }
    }

    private Map<Method, ?> takeSnapshot() throws InvocationTargetException, IllegalAccessException {
        HashMap<Method, Object> snapshot = new HashMap<Method, Object>();
        for (Method getter : this.getters) {
            Object value = getter.invoke(this.target, new Object[0]);
            snapshot.put(getter, value);
        }
        return snapshot;
    }

    static <I, T extends I> I newThrottlingBeanSnapshotProxy(Class<I> iface, T target, long updateInterval, Clock clock) {
        if (updateInterval == 0L) {
            return target;
        }
        Preconditions.checkArgument((boolean)iface.isInterface(), (String)"%s is not an interface", (Object[])new Object[]{iface});
        Preconditions.requirePositive((long)updateInterval);
        ThrottlingBeanSnapshotProxy proxy = new ThrottlingBeanSnapshotProxy(iface, target, updateInterval, clock);
        return iface.cast(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)proxy));
    }
}

