/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import javax.management.NotCompliantMBeanException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.jmx.StoreFile;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;

@Deprecated
public final class StoreFileBean
extends ManagementBeanProvider {
    public StoreFileBean() {
        super(StoreFile.class);
    }

    @Override
    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new StoreFileImpl(management);
    }

    static class StoreFileImpl
    extends Neo4jMBean
    implements StoreFile {
        private File databaseDirectory;
        private LogFiles logFiles;
        private FileSystemAbstraction fs;
        private DatabaseLayout databaseLayout;

        StoreFileImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.fs = management.getKernelData().getFilesystemAbstraction();
            DataSourceManager dataSourceManager = management.getKernelData().getDataSourceManager();
            dataSourceManager.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource ds) {
                    logFiles = this.resolveDependency(ds, LogFiles.class);
                    databaseLayout = ds.getDatabaseLayout();
                    databaseDirectory = this.resolveDatabaseDirectory();
                }

                private <T> T resolveDependency(NeoStoreDataSource ds, Class<T> clazz) {
                    return (T)ds.getDependencyResolver().resolveDependency(clazz);
                }

                public void unregistered(NeoStoreDataSource ds) {
                    logFiles = null;
                    databaseDirectory = null;
                    databaseLayout = null;
                }

                private File resolveDatabaseDirectory() {
                    return databaseLayout.databaseDirectory();
                }
            });
        }

        @Override
        public long getTotalStoreSize() {
            return this.databaseDirectory == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.databaseDirectory);
        }

        @Override
        public long getLogicalLogSize() {
            return this.logFiles == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.logFiles.getHighestLogFile());
        }

        @Override
        public long getArrayStoreSize() {
            return this.sizeOf(this.databaseLayout.propertyArrayStore());
        }

        @Override
        public long getNodeStoreSize() {
            return this.sizeOf(this.databaseLayout.nodeStore());
        }

        @Override
        public long getPropertyStoreSize() {
            return this.sizeOf(this.databaseLayout.propertyStore());
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.sizeOf(this.databaseLayout.relationshipStore());
        }

        @Override
        public long getStringStoreSize() {
            return this.sizeOf(this.databaseLayout.propertyStringStore());
        }

        private long sizeOf(File file) {
            return this.databaseDirectory == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)file);
        }
    }
}

