/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.jmx.StoreSize;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.jmx.impl.ThrottlingBeanSnapshotProxy;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.util.VisibleForTesting;

public final class StoreSizeBean
extends ManagementBeanProvider {
    private static final long UPDATE_INTERVAL = 60000L;
    private static final StoreSize NO_STORE_SIZE = new StoreSize(){

        @Override
        public long getTransactionLogsSize() {
            return 0L;
        }

        @Override
        public long getNodeStoreSize() {
            return 0L;
        }

        @Override
        public long getRelationshipStoreSize() {
            return 0L;
        }

        @Override
        public long getPropertyStoreSize() {
            return 0L;
        }

        @Override
        public long getStringStoreSize() {
            return 0L;
        }

        @Override
        public long getArrayStoreSize() {
            return 0L;
        }

        @Override
        public long getLabelStoreSize() {
            return 0L;
        }

        @Override
        public long getCountStoreSize() {
            return 0L;
        }

        @Override
        public long getSchemaStoreSize() {
            return 0L;
        }

        @Override
        public long getIndexStoreSize() {
            return 0L;
        }

        @Override
        public long getTotalStoreSize() {
            return 0L;
        }
    };

    public StoreSizeBean() {
        super(StoreSize.class);
    }

    @Override
    protected Neo4jMBean createMBean(ManagementData management) {
        return StoreSizeBean.createBean(management, false, 60000L, Clock.systemUTC());
    }

    @Override
    protected Neo4jMBean createMXBean(ManagementData management) {
        return StoreSizeBean.createBean(management, true, 60000L, Clock.systemUTC());
    }

    @VisibleForTesting
    static StoreSizeMBean createBean(ManagementData management, boolean isMxBean, long updateInterval, Clock clock) {
        StoreSizeMBean bean = new StoreSizeMBean(management, isMxBean, updateInterval, clock);
        DataSourceManager dataSourceManager = (DataSourceManager)management.resolveDependency(DataSourceManager.class);
        dataSourceManager.addListener((DataSourceManager.Listener)bean);
        return bean;
    }

    private static class StoreSizeProvider
    implements StoreSize {
        private final FileSystemAbstraction fs;
        private final File storePath;
        private final LogFiles logFiles;
        private final ExplicitIndexProviderLookup explicitIndexProviderLookup;
        private final IndexProviderMap indexProviderMap;
        private final LabelScanStore labelScanStore;

        private StoreSizeProvider(FileSystemAbstraction fs, File storePath, DependencyResolver deps) {
            this.fs = Objects.requireNonNull(fs);
            this.storePath = Objects.requireNonNull(storePath);
            this.logFiles = (LogFiles)deps.resolveDependency(LogFiles.class);
            this.explicitIndexProviderLookup = (ExplicitIndexProviderLookup)deps.resolveDependency(ExplicitIndexProviderLookup.class);
            this.indexProviderMap = (IndexProviderMap)deps.resolveDependency(IndexProviderMap.class);
            this.labelScanStore = (LabelScanStore)deps.resolveDependency(LabelScanStore.class);
        }

        @Override
        public long getTransactionLogsSize() {
            TotalSizeVersionVisitor logVersionVisitor = new TotalSizeVersionVisitor();
            this.logFiles.accept((LogVersionVisitor)logVersionVisitor);
            return logVersionVisitor.getTotalSize();
        }

        @Override
        public long getNodeStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.NODE_STORE, StoreFile.NODE_LABEL_STORE);
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE);
        }

        @Override
        public long getPropertyStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE);
        }

        @Override
        public long getStringStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.PROPERTY_STRING_STORE);
        }

        @Override
        public long getArrayStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.PROPERTY_ARRAY_STORE);
        }

        @Override
        public long getLabelStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE);
        }

        @Override
        public long getCountStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT);
        }

        @Override
        public long getSchemaStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.SCHEMA_STORE);
        }

        @Override
        public long getIndexStoreSize() {
            long size = 0L;
            for (IndexImplementation index : this.explicitIndexProviderLookup.all()) {
                size += FileUtils.size((FileSystemAbstraction)this.fs, (File)index.getIndexImplementationDirectory(this.storePath));
            }
            MutableLong schemaSize = new MutableLong();
            this.indexProviderMap.accept(provider -> {
                File rootDirectory = provider.directoryStructure().rootDirectory();
                if (rootDirectory != null) {
                    schemaSize.add(FileUtils.size((FileSystemAbstraction)this.fs, (File)rootDirectory));
                }
            });
            size += schemaSize.longValue();
            return size += FileUtils.size((FileSystemAbstraction)this.fs, (File)this.labelScanStore.getLabelScanStoreFile());
        }

        @Override
        public long getTotalStoreSize() {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.storePath);
        }

        private long sizeOf(String name) {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)new File(this.storePath, name));
        }

        private long sizeOfStoreFiles(StoreFile ... files) {
            long size = 0L;
            for (StoreFile file : files) {
                size += this.sizeOf(file.fileName(StoreFileType.STORE));
                if (!file.isRecordStore()) continue;
                size += this.sizeOf(file.fileName(StoreFileType.ID));
            }
            return size;
        }

        private class TotalSizeVersionVisitor
        implements LogVersionVisitor {
            private long totalSize;

            private TotalSizeVersionVisitor() {
            }

            long getTotalSize() {
                return this.totalSize;
            }

            public void visit(File file, long logVersion) {
                this.totalSize += FileUtils.size((FileSystemAbstraction)StoreSizeProvider.this.fs, (File)file);
            }
        }
    }

    static class StoreSizeMBean
    extends Neo4jMBean
    implements StoreSize,
    DataSourceManager.Listener {
        private final FileSystemAbstraction fs;
        private final File storePath;
        private final long updateInterval;
        private final Clock clock;
        private volatile StoreSize delegate = StoreSizeBean.access$000();

        StoreSizeMBean(ManagementData management, boolean isMXBean, long updateInterval, Clock clock) {
            super(management, isMXBean, new String[0]);
            this.fs = management.getKernelData().getFilesystemAbstraction();
            this.storePath = StoreSizeMBean.resolveStorePath(management);
            this.updateInterval = updateInterval;
            this.clock = clock;
        }

        public void registered(NeoStoreDataSource ds) {
            StoreSizeProvider dataProvider = new StoreSizeProvider(this.fs, this.storePath, ds.getDependencyResolver());
            this.delegate = ThrottlingBeanSnapshotProxy.newThrottlingBeanSnapshotProxy(StoreSize.class, dataProvider, this.updateInterval, this.clock);
        }

        public void unregistered(NeoStoreDataSource ds) {
            this.delegate = NO_STORE_SIZE;
        }

        @Override
        public long getTransactionLogsSize() {
            return this.delegate.getTransactionLogsSize();
        }

        @Override
        public long getNodeStoreSize() {
            return this.delegate.getNodeStoreSize();
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.delegate.getRelationshipStoreSize();
        }

        @Override
        public long getPropertyStoreSize() {
            return this.delegate.getPropertyStoreSize();
        }

        @Override
        public long getStringStoreSize() {
            return this.delegate.getStringStoreSize();
        }

        @Override
        public long getArrayStoreSize() {
            return this.delegate.getArrayStoreSize();
        }

        @Override
        public long getLabelStoreSize() {
            return this.delegate.getLabelStoreSize();
        }

        @Override
        public long getCountStoreSize() {
            return this.delegate.getCountStoreSize();
        }

        @Override
        public long getSchemaStoreSize() {
            return this.delegate.getSchemaStoreSize();
        }

        @Override
        public long getIndexStoreSize() {
            return this.delegate.getIndexStoreSize();
        }

        @Override
        public long getTotalStoreSize() {
            return this.delegate.getTotalStoreSize();
        }

        private static File resolveStorePath(ManagementData management) {
            File storeDir = management.getKernelData().getStoreDir();
            try {
                return storeDir.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                return storeDir.getAbsoluteFile();
            }
        }
    }
}

