/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.neo4j.jmx.Description;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.kernel.KernelData;

public abstract class Neo4jMBean
extends StandardMBean {
    final ObjectName objectName;

    protected Neo4jMBean(ManagementData management, boolean isMXBean) {
        super(management.provider.beanInterface, isMXBean);
        management.validate(this.getClass());
        this.objectName = management.getObjectName();
    }

    protected Neo4jMBean(ManagementData management) throws NotCompliantMBeanException {
        super(management.provider.beanInterface);
        management.validate(this.getClass());
        this.objectName = management.getObjectName();
    }

    Neo4jMBean(Class<Kernel> beanInterface, KernelData kernel, ManagementSupport support) throws NotCompliantMBeanException {
        super(beanInterface);
        this.objectName = support.createObjectName(kernel.instanceId(), beanInterface);
    }

    @Override
    protected String getClassName(MBeanInfo info) {
        Class<?> iface = this.getMBeanInterface();
        return iface == null ? super.getClassName(info) : iface.getName();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        Description description = this.describeClass();
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        Description description = this.describeMethod(info, "get", "is");
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        Description description = this.describeMethod(info, new String[0]);
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        Description description = this.describeMethod(info, new String[0]);
        if (description != null) {
            return description.impact();
        }
        return super.getImpact(info);
    }

    private Description describeClass() {
        Description description = this.getClass().getAnnotation(Description.class);
        if (description == null) {
            Class<?> iface;
            Class<?>[] arr$ = this.getClass().getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (description = (iface = arr$[i$]).getAnnotation(Description.class)) == null; ++i$) {
            }
        }
        return description;
    }

    private Description describeMethod(MBeanFeatureInfo info, String ... prefixes) {
        Description description = Neo4jMBean.describeMethod(this.getClass(), info.getName(), prefixes);
        if (description == null) {
            Class<?> iface;
            Class<?>[] arr$ = this.getClass().getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (description = Neo4jMBean.describeMethod(iface = arr$[i$], info.getName(), prefixes)) == null; ++i$) {
            }
        }
        return description;
    }

    private static Description describeMethod(Class<?> type, String methodName, String[] prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            try {
                return type.getMethod(methodName, new Class[0]).getAnnotation(Description.class);
            }
            catch (Exception e) {
                return null;
            }
        }
        for (String prefix : prefixes) {
            try {
                return type.getMethod(prefix + methodName, new Class[0]).getAnnotation(Description.class);
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

