/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import org.neo4j.helpers.Service;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.KernelData;

public abstract class ManagementBeanProvider
extends Service {
    final Class<?> beanInterface;

    public ManagementBeanProvider(Class<?> beanInterface) {
        super(ManagementSupport.beanName(beanInterface), new String[0]);
        if (DynamicMBean.class.isAssignableFrom(beanInterface)) {
            beanInterface = DynamicMBean.class;
        }
        this.beanInterface = beanInterface;
    }

    protected abstract Neo4jMBean createMBean(ManagementData var1) throws NotCompliantMBeanException;

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        return this.createMBean(management);
    }

    final Neo4jMBean loadBean(KernelData kernel, ManagementSupport support) {
        try {
            if (support.supportsMxBeans()) {
                return this.createMXBean(new ManagementData(this, kernel, support));
            }
            return this.createMBean(new ManagementData(this, kernel, support));
        }
        catch (Exception e) {
            return null;
        }
    }
}

