/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreparedStatementBuilder {
    private PreparedStatementBuilder() {
    }

    public static String replacePlaceholders(String raw) {
        int index = 1;
        String digested = raw;
        String regex = "\\?(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)";
        Matcher matcher = Pattern.compile(regex).matcher(digested);
        while (matcher.find()) {
            digested = digested.replaceFirst(regex, "\\$" + index);
            ++index;
        }
        return digested;
    }

    public static int namedParameterCount(String raw) {
        int max = 0;
        String regex = "\\$\\s*`?\\s*(\\d+)\\s*`?\\s*(?=[^\"]*(\"[^\"]*\"[^\"]*)*$)";
        Matcher matcher = Pattern.compile(regex).matcher(raw);
        while (matcher.find()) {
            max = Math.max(Integer.parseInt(matcher.group(1)), max);
        }
        return max;
    }
}

