/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.Value;

final class ValueUtils {
    private ValueUtils() {
        throw new UnsupportedOperationException();
    }

    static <T> Map<String, T> map(Record record, Function<Value, T> mapFunction) {
        int size = record.size();
        switch (size) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap((String)record.keys().get(0), mapFunction.apply(record.get(0)));
            }
        }
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>(size);
        Iterable keys = record.keys();
        for (int i = 0; i < size; ++i) {
            map.put((String)keys.get(i), mapFunction.apply(record.get(i)));
        }
        return Collections.unmodifiableMap(map);
    }
}

