/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Objects;
import org.neo4j.jdbc.values.AbstractValue;
import org.neo4j.jdbc.values.Type;

public final class StringValue
extends AbstractValue {
    private final String val;

    StringValue(String val) {
        this.val = Objects.requireNonNull(val, "Cannot construct StringValue from null");
    }

    @Override
    public boolean isEmpty() {
        return this.val.isEmpty();
    }

    @Override
    public int size() {
        return this.val.length();
    }

    @Override
    public String asObject() {
        return this.asString();
    }

    @Override
    public String asString() {
        return this.val;
    }

    @Override
    public Type type() {
        return Type.STRING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return Objects.equals(this.val, that.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public String toString() {
        return String.format("\"%s\"", this.val.replace("\"", "\\\""));
    }
}

