/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.jdbc.values.AbstractMapAccessorWithDefaultValue;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.ValueUtils;
import org.neo4j.jdbc.values.Values;

final class RecordImpl
extends AbstractMapAccessorWithDefaultValue
implements Record {
    private final List<String> keys;
    private final Value[] values;
    private int hashCode;

    RecordImpl(List<String> keys, Value[] values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public List<Value> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return this.values().stream().map(mapFunction).collect(Collectors.toList());
    }

    @Override
    public int index(String key) {
        int result = this.keys.indexOf(key);
        if (result == -1) {
            throw new NoSuchElementException("Unknown key: " + key);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public Value get(String key) {
        int fieldIndex = this.keys.indexOf(key);
        if (fieldIndex == -1) {
            return Values.NULL;
        }
        return this.values[fieldIndex];
    }

    @Override
    public Value get(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Map<String, Object> asMap() {
        return ValueUtils.map(this, Value::asObject);
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapper) {
        return ValueUtils.map(this, mapper);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Record) {
            Record otherRecord = (Record)other;
            int size = this.size();
            if (size != otherRecord.size()) {
                return false;
            }
            if (!this.keys.equals(otherRecord.keys())) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Value otherValue;
                Value value = this.get(i);
                if (value.equals(otherValue = otherRecord.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * this.keys.hashCode() + Arrays.hashCode(this.values);
        }
        return this.hashCode;
    }

    public String toString() {
        return String.format("Record<%s>", RecordImpl.formatPairs(this.asMap(Values.ofValue())));
    }
}

